/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import hudson.model.AbstractModelObject;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Hudson;
import hudson.scm.RevisionParameterAction;
import hudson.scm.SCM;
import hudson.scm.SubversionSCM;
import hudson.triggers.SCMTrigger;
import hudson.util.QueryParameterMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.tmatesoft.svn.core.SVNException;

public class SubversionRepositoryStatus
extends AbstractModelObject {
    public final UUID uuid;
    private static final Logger LOGGER = Logger.getLogger(SubversionRepositoryStatus.class.getName());

    public SubversionRepositoryStatus(UUID uuid) {
        this.uuid = uuid;
    }

    public String getDisplayName() {
        return this.uuid.toString();
    }

    public String getSearchUrl() {
        return this.uuid.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doNotifyCommit(StaplerRequest req, StaplerResponse rsp) throws ServletException, IOException {
        this.requirePOST();
        HashSet<String> affectedPath = new HashSet<String>();
        BufferedReader r = new BufferedReader(req.getReader());
        try {
            String line;
            while ((line = r.readLine()) != null) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("Reading line: " + line);
                }
                affectedPath.add(line.substring(4));
                if (!line.startsWith("svnlook changed --revision ")) continue;
                String msg = "Expecting the output from the svnlook command but instead you just sent me the svnlook invocation command line: " + line;
                LOGGER.warning(msg);
                throw new IllegalArgumentException(msg);
            }
        }
        finally {
            IOUtils.closeQuietly((Reader)r);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Change reported to Subversion repository " + this.uuid + " on " + affectedPath);
        }
        boolean scmFound = false;
        boolean triggerFound = false;
        boolean uuidFound = false;
        boolean pathFound = false;
        QueryParameterMap query = new QueryParameterMap((HttpServletRequest)req);
        String revParam = query.get("rev");
        long rev = -1L;
        if (revParam != null) {
            rev = Long.parseLong(revParam);
        } else {
            revParam = req.getHeader("X-Hudson-Subversion-Revision");
            if (revParam != null) {
                rev = Long.parseLong(revParam);
            }
        }
        block6: for (AbstractProject p : Hudson.getInstance().getItems(AbstractProject.class)) {
            try {
                SCM scm = p.getScm();
                if (!(scm instanceof SubversionSCM)) continue;
                scmFound = true;
                SCMTrigger trigger = (SCMTrigger)p.getTrigger(SCMTrigger.class);
                if (trigger == null) continue;
                triggerFound = true;
                if (p.isDisabled()) continue;
                SubversionSCM sscm = (SubversionSCM)scm;
                for (SubversionSCM.ModuleLocation loc : sscm.getLocations()) {
                    RevisionParameterAction[] actions;
                    String n;
                    if (!loc.getUUID(p).equals(this.uuid)) continue;
                    uuidFound = true;
                    String m = loc.getSVNURL().getPath();
                    if (!m.startsWith(n = loc.getRepositoryRoot(p).getPath())) continue;
                    String remaining = m.substring(n.length());
                    if (remaining.startsWith("/")) {
                        remaining = remaining.substring(1);
                    }
                    String remainingSlash = remaining + '/';
                    if (rev != -1L) {
                        SubversionSCM.SvnInfo[] info = new SubversionSCM.SvnInfo[]{new SubversionSCM.SvnInfo(loc.getURL(), rev)};
                        RevisionParameterAction action = new RevisionParameterAction(info);
                        actions = new RevisionParameterAction[]{action};
                    } else {
                        actions = new RevisionParameterAction[]{};
                    }
                    for (String path : affectedPath) {
                        if (!path.equals(remaining) && !path.startsWith(remainingSlash)) continue;
                        LOGGER.info("Scheduling the immediate polling of " + p);
                        trigger.run((Action[])actions);
                        pathFound = true;
                        continue block6;
                    }
                }
            }
            catch (SVNException e) {
                LOGGER.log(Level.WARNING, "Failed to handle Subversion commit notification", e);
            }
        }
        if (!scmFound) {
            LOGGER.warning("No subversion jobs found");
        } else if (!triggerFound) {
            LOGGER.warning("No subversion jobs using SCM polling");
        } else if (!uuidFound) {
            LOGGER.warning("No enabled subversion jobs using repository: " + this.uuid);
        } else if (!pathFound) {
            LOGGER.fine("No jobs found matching the modified files");
        }
        rsp.setStatus(200);
    }
}

