/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm.browsers;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.scm.RepositoryBrowser;
import hudson.scm.SubversionChangeLogSet;
import hudson.scm.SubversionRepositoryBrowser;
import hudson.util.FormValidation;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class WebSVN2
extends SubversionRepositoryBrowser {
    private static final String CHANGE_SET_FORMAT = "revision.php?%1srev=%2d";
    private static final String DIFF_FORMAT = "diff.php?%1spath=%2s&rev=%3d";
    private static final String FILE_FORMAT = "filedetails.php?%1spath=%2s&rev=%3d";
    private static final Pattern URL_PATTERN = Pattern.compile("(.*/)(revision|diff|comp|filedetails|listing|blame|dl|log)\\.php([^?]*)\\?(repname=([^&]*))?(.*)");
    private static final int URL_PATTERN_BASE_URL_GROUP = 1;
    private static final int URL_PATTERN_REPNAME_GROUP = 4;
    public final URL url;
    private final URL baseUrl;
    private final String repname;

    @DataBoundConstructor
    public WebSVN2(URL url) throws MalformedURLException {
        Matcher webSVNurl = URL_PATTERN.matcher(url.toString());
        this.url = url;
        if (!webSVNurl.matches()) {
            this.repname = "";
            this.baseUrl = url;
        } else {
            this.baseUrl = new URL(webSVNurl.group(1));
            this.repname = webSVNurl.group(4) + "&";
        }
    }

    public URL getDiffLink(SubversionChangeLogSet.Path path) throws IOException {
        return new URL(this.baseUrl, String.format(DIFF_FORMAT, this.repname, URLEncoder.encode(path.getValue(), "UTF-8"), path.getLogEntry().getRevision()));
    }

    public URL getFileLink(SubversionChangeLogSet.Path path) throws IOException {
        return new URL(this.baseUrl, String.format(FILE_FORMAT, this.repname, URLEncoder.encode(path.getValue(), "UTF-8"), path.getLogEntry().getRevision()));
    }

    public URL getChangeSetLink(SubversionChangeLogSet.LogEntry logEntry) throws IOException {
        return new URL(this.baseUrl, String.format(CHANGE_SET_FORMAT, this.repname, logEntry.getRevision()));
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WebSVN2)) {
            return false;
        }
        WebSVN2 that = (WebSVN2)((Object)o);
        return new EqualsBuilder().append((Object)this.baseUrl, (Object)that.baseUrl).append((Object)this.repname, (Object)that.repname).append((Object)this.url, (Object)that.url).isEquals();
    }

    public final int hashCode() {
        return new HashCodeBuilder().append((Object)this.baseUrl).append((Object)this.repname).append((Object)this.url).toHashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends Descriptor<RepositoryBrowser<?>> {
        public String getDisplayName() {
            return "WebSVN2";
        }

        public FormValidation doCheckUrl(@AncestorInPath AbstractProject project, @QueryParameter(fixEmpty=true) String value) {
            FormValidation result;
            block6: {
                if (value == null) {
                    return FormValidation.ok();
                }
                Matcher matcher = URL_PATTERN.matcher(value);
                if (matcher.matches()) {
                    try {
                        new URL(matcher.group(1));
                        String repName = matcher.group(4);
                        if (StringUtils.isBlank((String)repName)) {
                            result = FormValidation.okWithMarkup((String)"Please set a url including the repname property if needed.");
                            break block6;
                        }
                        result = FormValidation.ok();
                    }
                    catch (MalformedURLException ex) {
                        result = FormValidation.error((String)("The entered url is not accepted: " + ex.getLocalizedMessage()));
                    }
                } else {
                    result = StringUtils.isBlank((String)value) ? FormValidation.okWithMarkup((String)"Please set a WebSVN url in the form https://<i>server</i>/websvn/listing.php?repname=<i>rep</i>&path=/trunk/..") : FormValidation.error((String)"Please set a url including the WebSVN php script.");
                }
            }
            return result;
        }
    }
}

