/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm.subversion;

import hudson.remoting.Which;
import hudson.scm.SubversionEventHandlerImpl;
import hudson.scm.SubversionSCM;
import hudson.scm.subversion.Messages;
import hudson.scm.subversion.SVNEvent;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc.SVNExternal;
import org.tmatesoft.svn.core.wc.ISVNExternalsHandler;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNRevision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SubversionUpdateEventHandler
extends SubversionEventHandlerImpl
implements ISVNExternalsHandler {
    private static final Logger LOGGER = Logger.getLogger(SubversionUpdateEventHandler.class.getName());
    private final List<SubversionSCM.External> externals;
    private final String modulePath;

    public SubversionUpdateEventHandler(PrintStream out, List<SubversionSCM.External> externals, File moduleDir, String modulePath) {
        super(out, moduleDir);
        this.externals = externals;
        this.modulePath = modulePath;
    }

    public void handleEvent(SVNEvent event, double progress) throws SVNException {
        File file = event.getFile();
        String path = null;
        try {
            path = this.getRelativePath(file);
        }
        catch (IOException e) {
            throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.FS_GENERAL), (Throwable)e);
        }
        path = SubversionUpdateEventHandler.getLocalPath(path);
        SVNEventAction action = event.getAction();
        if (action == SVNEventAction.UPDATE_EXTERNAL) {
            SVNExternal ext = event.getExternalInfo();
            if (ext == null) {
                URL jarFile = null;
                try {
                    jarFile = Which.jarURL(SVNEvent.class);
                }
                catch (IOException e) {
                    LOGGER.log(Level.FINEST, "Exception occurred while loading SVNEvent", e);
                }
                this.out.println("AssertionError: appears to be using unpatched svnkit at " + jarFile);
            } else {
                this.out.println(Messages.SubversionUpdateEventHandler_FetchExternal(ext.getResolvedURL(), ext.getRevision().getNumber(), event.getFile()));
                this.externals.add(new SubversionSCM.External(this.modulePath + "/" + path.substring(0, path.length() - ext.getPath().length()), ext));
            }
            return;
        }
        if (action == SVNEventAction.SKIP && event.getExpectedAction() == SVNEventAction.UPDATE_EXTERNAL && event.getNodeKind() == SVNNodeKind.FILE) {
            this.out.println("svn:externals to a file requires Subversion 1.6 workspace support. Use the system configuration to enable that.");
        }
        super.handleEvent(event, progress);
    }

    public void checkCancelled() throws SVNCancelException {
        if (Thread.interrupted()) {
            throw new SVNCancelException();
        }
    }

    public SVNRevision[] handleExternal(File externalPath, SVNURL externalURL, SVNRevision externalRevision, SVNRevision externalPegRevision, String externalsDefinition, SVNRevision externalsWorkingRevision) {
        this.externals.add(new SubversionSCM.External(externalPath.getAbsolutePath(), externalURL, externalRevision.getNumber()));
        return new SVNRevision[]{externalRevision, externalPegRevision};
    }
}

