/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testng;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.plugins.testng.Publisher;
import hudson.plugins.testng.TestNGBuildAction;
import hudson.plugins.testng.TestNGProjectAction;
import hudson.plugins.testng.results.TestResults;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Recorder;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class Publisher
extends Recorder {
    public final String reportFilenamePattern;
    private boolean isRelativePath;
    public final boolean escapeTestDescp;
    public final boolean escapeExceptionMsg;
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl(null);

    @DataBoundConstructor
    public Publisher(String reportFilenamePattern, boolean escapeTestDescp, boolean escapeExceptionMsg) {
        reportFilenamePattern.getClass();
        this.reportFilenamePattern = reportFilenamePattern;
        this.escapeTestDescp = escapeTestDescp;
        this.escapeExceptionMsg = escapeExceptionMsg;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.STEP;
    }

    public BuildStepDescriptor<hudson.tasks.Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    public Collection<? extends Action> getProjectActions(AbstractProject<?, ?> project) {
        ArrayList<TestNGProjectAction> actions = new ArrayList<TestNGProjectAction>();
        actions.add(new TestNGProjectAction(project, this.escapeTestDescp, this.escapeExceptionMsg));
        return actions;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        PrintStream logger = listener.getLogger();
        logger.println("TestNG Reports Processing: START");
        logger.println("Looking for TestNG results report in workspace using pattern: " + this.reportFilenamePattern);
        FilePath[] paths = Publisher.locateReports((FilePath)build.getWorkspace(), (String)this.reportFilenamePattern);
        if (paths.length == 0) {
            logger.println("Did not find any matching files.");
            return true;
        }
        paths = Publisher.checkReports(build, (FilePath[])paths, (PrintStream)logger);
        boolean filesSaved = Publisher.saveReports((FilePath)Publisher.getTestNGReport(build), (FilePath[])paths, (PrintStream)logger);
        if (!filesSaved) {
            logger.println("Failed to save TestNG XML reports");
            return true;
        }
        TestResults results = new TestResults("");
        try {
            results = TestNGBuildAction.loadResults(build, (PrintStream)logger);
        }
        catch (Throwable t) {
            t.printStackTrace(logger);
        }
        if (results.getTestList().size() > 0) {
            TestNGBuildAction action = new TestNGBuildAction(build, results);
            build.getActions().add(action);
            if (results.getFailedConfigCount() > 0 || results.getFailedTestCount() > 0) {
                build.setResult(Result.UNSTABLE);
            }
        } else {
            logger.println("Found matching files but did not find any TestNG results.");
            return true;
        }
        logger.println("TestNG Reports Processing: FINISH");
        return true;
    }

    static FilePath[] locateReports(FilePath workspace, String filenamePattern) throws IOException, InterruptedException {
        String[] parts;
        try {
            FilePath[] ret = workspace.list(filenamePattern);
            if (ret.length > 0) {
                return ret;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        ArrayList<FilePath> files = new ArrayList<FilePath>();
        for (String path : parts = filenamePattern.split("\\s*[;:,]+\\s*")) {
            FilePath src = workspace.child(path);
            if (!src.exists()) continue;
            if (src.isDirectory()) {
                files.addAll(Arrays.asList(src.list("**/testng*.xml")));
                continue;
            }
            files.add(src);
        }
        return files.toArray(new FilePath[files.size()]);
    }

    static FilePath getTestNGReport(AbstractBuild<?, ?> build) {
        return new FilePath(new File(build.getRootDir(), "testng"));
    }

    static FilePath[] checkReports(AbstractBuild<?, ?> build, FilePath[] paths, PrintStream logger) {
        ArrayList<FilePath> filePathList = new ArrayList<FilePath>(paths.length);
        for (FilePath report : paths) {
            try {
                if (build.getTimestamp().getTimeInMillis() / 1000L <= report.lastModified() / 1000L) {
                    filePathList.add(report);
                    continue;
                }
                logger.println(report.getName() + " was last modified before " + "this build started. Ignoring it.");
            }
            catch (IOException e) {
                e.printStackTrace(logger);
            }
            catch (InterruptedException e) {
                e.printStackTrace(logger);
            }
        }
        return filePathList.toArray(new FilePath[0]);
    }

    static boolean saveReports(FilePath testngDir, FilePath[] paths, PrintStream logger) {
        logger.println("Saving reports...");
        try {
            testngDir.mkdirs();
            int i = 0;
            for (FilePath report : paths) {
                String name = "testng-results" + (i > 0 ? "-" + i : "") + ".xml";
                ++i;
                FilePath dst = testngDir.child(name);
                report.copyTo(dst);
            }
        }
        catch (Exception e) {
            e.printStackTrace(logger);
            return false;
        }
        return true;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        return true;
    }
}

