/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testng;

import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.Api;
import hudson.plugins.testng.Publisher;
import hudson.plugins.testng.parser.ResultsParser;
import hudson.plugins.testng.results.TestResults;
import hudson.plugins.testng.util.TestResultHistoryUtil;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class TestNGBuildAction
implements Action,
Serializable {
    private static final long serialVersionUID = 31415926L;
    private final AbstractBuild<?, ?> build;
    private transient TestResults results;
    private transient Reference<TestResults> testResults;
    private transient int passedTestCount;
    private transient int failedTestCount;
    private transient int skippedTestCount;

    public TestNGBuildAction(AbstractBuild<?, ?> build, TestResults testngResults) {
        this.build = build;
        testngResults.setOwner(this.build);
        this.testResults = new WeakReference<TestResults>(testngResults);
        this.passedTestCount = testngResults.getPassedTestCount();
        this.failedTestCount = testngResults.getFailedTestCount();
        this.skippedTestCount = testngResults.getSkippedTestCount();
    }

    public synchronized AbstractBuild<?, ?> getBuild() {
        return this.build;
    }

    public boolean isFloatingBoxActive() {
        return true;
    }

    public boolean isGraphActive() {
        return false;
    }

    public TestResults getResults() {
        if (this.results == null) {
            if (this.testResults == null) {
                this.testResults = new WeakReference<TestResults>(TestNGBuildAction.loadResults((AbstractBuild)this.getBuild(), null));
                return (TestResults)this.testResults.get();
            }
            TestResults tr = (TestResults)this.testResults.get();
            if (tr == null) {
                this.testResults = new WeakReference<TestResults>(TestNGBuildAction.loadResults((AbstractBuild)this.getBuild(), null));
                return (TestResults)this.testResults.get();
            }
            return tr;
        }
        return this.results;
    }

    static TestResults loadResults(AbstractBuild<?, ?> owner, PrintStream logger) {
        FilePath testngDir = Publisher.getTestNGReport(owner);
        FilePath[] paths = null;
        try {
            paths = testngDir.list("testng-results*.xml");
        }
        catch (Exception e) {
            // empty catch block
        }
        TestResults tr = null;
        if (paths == null) {
            tr = new TestResults("");
            tr.setOwner(owner);
            return tr;
        }
        ResultsParser parser = new ResultsParser(logger);
        TestResults result = parser.parse(paths);
        result.setOwner(owner);
        return result;
    }

    public String getSummary() {
        return TestResultHistoryUtil.toSummary((TestNGBuildAction)this);
    }

    public String getIconFileName() {
        return "/plugin/testng-plugin/icons/report.png";
    }

    public String getDisplayName() {
        return "TestNG Results";
    }

    public String getUrlName() {
        return "testngreports";
    }

    public Object getDynamic(String token, StaplerRequest req, StaplerResponse rsp) {
        return this.getResults().getDynamic(token, req, rsp);
    }

    public Api getApi() {
        return new Api((Object)this.getResults());
    }

    public int getPassedTestCount() {
        return this.passedTestCount;
    }

    public int getFailedTestCount() {
        return this.failedTestCount;
    }

    public int getSkippedTestCount() {
        return this.skippedTestCount;
    }

    protected Object readResolve() {
        TestResults testResults = this.getResults();
        this.passedTestCount = testResults.getPassedTestCount();
        this.failedTestCount = testResults.getFailedTestCount();
        this.skippedTestCount = testResults.getSkippedTestCount();
        return this;
    }
}

