/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testng.parser;

import hudson.FilePath;
import hudson.plugins.testng.parser.ResultsParser;
import hudson.plugins.testng.results.ClassResult;
import hudson.plugins.testng.results.MethodResult;
import hudson.plugins.testng.results.MethodResultException;
import hudson.plugins.testng.results.TestResult;
import hudson.plugins.testng.results.TestResults;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ResultsParser {
    private static final Logger log = Logger.getLogger(ResultsParser.class.getName());
    public static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    public static XmlPullParserFactory PARSER_FACTORY;
    private final DateFormat dateFormat;
    private PrintStream logger;
    private Map<String, TestResult> testResultMap = new HashMap();
    private Map<String, ClassResult> classResultMap = new HashMap();
    private Map<String, List<String>> methodGroupMap = new HashMap();
    private TestResults finalResults;
    private List<TestResult> testList;
    private List<ClassResult> currentClassList;
    private List<MethodResult> currentMethodList;
    private List<String> currentMethodParamsList;
    private TestResult currentTest;
    private ClassResult currentClass;
    private String currentTestRunId;
    private MethodResult currentMethod;
    private XmlPullParser xmlPullParser;
    private TAGS currentCDATAParent = TAGS.UNKNOWN;
    private String currentMessage;
    private String currentShortStackTrace;
    private String currentFullStackTrace;
    private String currentGroupName;
    private String currentSuite;

    public ResultsParser() {
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    }

    public ResultsParser(PrintStream logger) {
        this();
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestResults parse(FilePath[] paths) {
        if (null == paths) {
            this.log("File paths not specified. paths var is null. Returning empty test results.");
            return new TestResults("");
        }
        this.finalResults = new TestResults(UUID.randomUUID().toString());
        for (FilePath path : paths) {
            File file = new File(path.getRemote());
            if (!file.isFile()) {
                this.log("'" + file.getAbsolutePath() + "' points to an invalid test report");
                continue;
            }
            this.log("Processing '" + file.getAbsolutePath() + "'");
            BufferedInputStream bufferedInputStream = null;
            try {
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                this.xmlPullParser = this.createXmlPullParser(bufferedInputStream);
                this.testList = new ArrayList();
                while (1 != this.xmlPullParser.nextToken()) {
                    TAGS tag = TAGS.fromString((String)this.xmlPullParser.getName());
                    int eventType = this.xmlPullParser.getEventType();
                    block9 : switch (eventType) {
                        case 2: {
                            switch (1.$SwitchMap$hudson$plugins$testng$parser$ResultsParser$TAGS[tag.ordinal()]) {
                                case 1: {
                                    this.startSuite(this.get("name"));
                                    break block9;
                                }
                                case 2: {
                                    this.startGroups();
                                    break block9;
                                }
                                case 3: {
                                    this.startGroup(this.get("name"));
                                    break block9;
                                }
                                case 4: {
                                    this.startGroupMethod(this.get("class"), this.get("name"));
                                    break block9;
                                }
                                case 5: {
                                    this.startTest(this.get("name"));
                                    break block9;
                                }
                                case 6: {
                                    this.startClass(this.get("name"));
                                    break block9;
                                }
                                case 7: {
                                    this.startTestMethod(this.get("name"), this.get("test-instance-name"), this.get("status"), this.get("description"), this.get("duration-ms"), this.get("started-at"), this.get("is-config"));
                                    break block9;
                                }
                                case 8: {
                                    this.startMethodParameters();
                                    this.currentCDATAParent = TAGS.PARAMS;
                                    break block9;
                                }
                                case 9: {
                                    this.startException();
                                    break block9;
                                }
                                case 10: {
                                    this.currentCDATAParent = TAGS.MESSAGE;
                                    break block9;
                                }
                                case 11: {
                                    this.currentCDATAParent = TAGS.SHORT_STACKTRACE;
                                    break block9;
                                }
                                case 12: {
                                    this.currentCDATAParent = TAGS.FULL_STACKTRACE;
                                }
                            }
                            break;
                        }
                        case 3: {
                            switch (1.$SwitchMap$hudson$plugins$testng$parser$ResultsParser$TAGS[tag.ordinal()]) {
                                case 1: {
                                    this.finishSuite();
                                    break block9;
                                }
                                case 3: {
                                    this.finishGroup();
                                    break block9;
                                }
                                case 4: {
                                    this.finishGroupMethod();
                                    break block9;
                                }
                                case 5: {
                                    this.finishTest();
                                    break block9;
                                }
                                case 6: {
                                    this.finishclass();
                                    break block9;
                                }
                                case 7: {
                                    this.finishTestMethod();
                                    break block9;
                                }
                                case 8: {
                                    this.finishMethodParameters();
                                    this.currentCDATAParent = TAGS.UNKNOWN;
                                    break block9;
                                }
                                case 9: {
                                    this.finishException();
                                    break block9;
                                }
                                case 10: 
                                case 11: 
                                case 12: {
                                    this.currentCDATAParent = TAGS.UNKNOWN;
                                }
                            }
                            break;
                        }
                        case 5: {
                            this.handleCDATA();
                        }
                    }
                }
                this.finalResults.addUniqueTests(this.testList);
            }
            catch (XmlPullParserException e) {
                this.log("Failed to parse XML: " + e.getMessage());
                this.log((Exception)((Object)e));
            }
            catch (FileNotFoundException e) {
                this.log("Failed to find XML file");
                this.log((Exception)e);
            }
            catch (IOException e) {
                this.log((Exception)e);
            }
            finally {
                try {
                    if (bufferedInputStream != null) {
                        bufferedInputStream.close();
                    }
                }
                catch (IOException e) {
                    this.log((Exception)e);
                }
            }
        }
        this.finalResults.tally();
        return this.finalResults;
    }

    private void startGroupMethod(String className, String methodName) {
        String key = className + "|" + methodName;
        ArrayList<String> groups = (ArrayList<String>)this.methodGroupMap.get(key);
        if (groups == null) {
            groups = new ArrayList<String>(3);
            groups.add(this.currentGroupName);
            this.methodGroupMap.put(key, groups);
        } else {
            groups.add(this.currentGroupName);
        }
    }

    private void finishGroupMethod() {
    }

    private void startGroup(String groupName) {
        this.currentGroupName = groupName;
    }

    private void finishGroup() {
        this.currentGroupName = null;
    }

    private void startGroups() {
        this.methodGroupMap = new HashMap();
    }

    private void startSuite(String name) {
        this.currentSuite = name;
    }

    private void finishSuite() {
        this.methodGroupMap.clear();
        this.currentSuite = null;
    }

    private void startException() {
    }

    private void finishException() {
        if (this.currentShortStackTrace == null && this.currentFullStackTrace == null) {
            this.log("Something is wrong with TestNG result XML. Didn't find stacktraces for the exception.");
            return;
        }
        MethodResultException mrEx = new MethodResultException(this.currentMessage, this.currentShortStackTrace, this.currentFullStackTrace);
        this.currentMethod.setException(mrEx);
        mrEx = null;
        this.currentMessage = null;
        this.currentShortStackTrace = null;
        this.currentFullStackTrace = null;
    }

    private void startMethodParameters() {
        this.currentMethodParamsList = new ArrayList();
    }

    private void finishMethodParameters() {
        this.currentMethod.setParameters(this.currentMethodParamsList);
        this.currentMethodParamsList = null;
    }

    private void handleCDATA() {
        switch (1.$SwitchMap$hudson$plugins$testng$parser$ResultsParser$TAGS[this.currentCDATAParent.ordinal()]) {
            case 8: {
                this.currentMethodParamsList.add(this.xmlPullParser.getText());
                break;
            }
            case 10: {
                this.currentMessage = this.xmlPullParser.getText();
                break;
            }
            case 12: {
                this.currentFullStackTrace = this.xmlPullParser.getText();
                break;
            }
            case 11: {
                this.currentShortStackTrace = this.xmlPullParser.getText();
                break;
            }
        }
    }

    private void startTestMethod(String name, String testInstanceName, String status, String description, String duration, String startedAt, String isConfig) {
        Date startedAtDate;
        try {
            startedAtDate = this.dateFormat.parse(startedAt);
        }
        catch (ParseException e) {
            this.log("Unable to parse started-at value: " + startedAt);
            startedAtDate = null;
        }
        this.currentMethod = new MethodResult(name, status, description, duration, startedAtDate, isConfig, this.currentTestRunId, this.currentTest.getName(), this.currentSuite, testInstanceName);
        List groups = (List)this.methodGroupMap.get(this.currentClass.getName() + "|" + name);
        if (groups != null) {
            this.currentMethod.setGroups(groups);
        }
    }

    private void finishTestMethod() {
        this.updateTestMethodLists(this.currentMethod);
        this.currentMethodList.add(this.currentMethod);
        this.currentMethod = null;
    }

    private void startClass(String name) {
        if (this.classResultMap.containsKey(name)) {
            this.currentClass = (ClassResult)this.classResultMap.get(name);
        } else {
            this.currentClass = new ClassResult(name);
            this.classResultMap.put(name, this.currentClass);
        }
        this.currentMethodList = new ArrayList();
        this.currentTestRunId = UUID.randomUUID().toString();
    }

    private void finishclass() {
        this.currentClass.addTestMethods(this.currentMethodList);
        this.currentClassList.add(this.currentClass);
        this.currentMethodList = null;
        this.currentClass = null;
        this.currentTestRunId = null;
    }

    private void startTest(String name) {
        if (this.testResultMap.containsKey(name)) {
            this.currentTest = (TestResult)this.testResultMap.get(name);
        } else {
            this.currentTest = new TestResult(name);
            this.testResultMap.put(name, this.currentTest);
        }
        this.currentClassList = new ArrayList();
    }

    private void finishTest() {
        this.currentTest.addClassList(this.currentClassList);
        this.testList.add(this.currentTest);
        this.currentClassList = null;
        this.currentTest = null;
    }

    private void updateTestMethodLists(MethodResult testMethod) {
        if (testMethod.isConfig()) {
            if ("FAIL".equals(testMethod.getStatus())) {
                this.finalResults.getFailedConfigs().add(testMethod);
            } else if ("SKIP".equals(testMethod.getStatus())) {
                this.finalResults.getSkippedConfigs().add(testMethod);
            }
        } else if ("FAIL".equals(testMethod.getStatus())) {
            this.finalResults.getFailedTests().add(testMethod);
        } else if ("SKIP".equals(testMethod.getStatus())) {
            this.finalResults.getSkippedTests().add(testMethod);
        } else if ("PASS".equals(testMethod.getStatus())) {
            this.finalResults.getPassedTests().add(testMethod);
        }
    }

    private String get(String attr) {
        return this.xmlPullParser.getAttributeValue(null, attr);
    }

    private XmlPullParser createXmlPullParser(BufferedInputStream bufferedInputStream) throws XmlPullParserException {
        if (PARSER_FACTORY == null) {
            throw new XmlPullParserException("XML Parser Factory has not been initiallized properly");
        }
        XmlPullParser xmlPullParser = PARSER_FACTORY.newPullParser();
        xmlPullParser.setInput((InputStream)bufferedInputStream, null);
        return xmlPullParser;
    }

    private void log(String str) {
        if (this.logger != null) {
            this.logger.println(str);
        } else {
            log.fine(str);
        }
    }

    private void log(Exception ex) {
        if (this.logger != null) {
            ex.printStackTrace(this.logger);
        } else {
            log.severe(ex.toString());
        }
    }

    static {
        try {
            PARSER_FACTORY = XmlPullParserFactory.newInstance();
            PARSER_FACTORY.setNamespaceAware(true);
            PARSER_FACTORY.setValidating(false);
        }
        catch (XmlPullParserException e) {
            log.severe(e.toString());
        }
    }
}

