/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testng.results;

import hudson.model.AbstractBuild;
import hudson.plugins.testng.TestNGBuildAction;
import hudson.plugins.testng.TestNGProjectAction;
import hudson.plugins.testng.results.BaseResult;
import hudson.plugins.testng.results.ClassResult;
import hudson.plugins.testng.results.MethodResultException;
import hudson.plugins.testng.results.PackageResult;
import hudson.plugins.testng.results.TestResults;
import hudson.plugins.testng.util.FormatUtil;
import hudson.util.ChartUtil;
import hudson.util.DataSetBuilder;
import hudson.util.Graph;
import java.io.IOException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodResult
extends BaseResult {
    private String status;
    private String description;
    private boolean isConfig;
    private long duration;
    private MethodResultException exception;
    private Date startedAt;
    private String testInstanceName;
    private String parentTestName;
    private String parentSuiteName;
    private List<String> groups;
    private List<String> parameters;
    private String testRunId;
    private String testUuid;

    public MethodResult(String name, String status, String description, String duration, Date startedAt, String isConfig, String testRunId, String parentTestName, String parentSuiteName, String testInstanceName) {
        super(name);
        this.status = status;
        this.description = description;
        this.testRunId = testRunId;
        this.testInstanceName = testInstanceName;
        this.parentTestName = parentTestName;
        this.parentSuiteName = parentSuiteName;
        this.startedAt = startedAt;
        try {
            this.duration = Long.parseLong(duration);
        }
        catch (NumberFormatException e) {
            System.err.println("Unable to parse duration value: " + duration);
        }
        if (isConfig != null) {
            this.isConfig = true;
        }
    }

    public String getTestUuid() {
        return this.testUuid;
    }

    public void setTestUuid(String testUuid) {
        this.testUuid = testUuid;
    }

    public String getTestInstanceName() {
        return this.testInstanceName;
    }

    public String getParentTestName() {
        return this.parentTestName;
    }

    public String getParentSuiteName() {
        return this.parentSuiteName;
    }

    public String getTestRunId() {
        return this.testRunId;
    }

    @Exported
    public Date getStartedAt() {
        return this.startedAt;
    }

    public String getFullUrl() {
        return super.getParent().getParent().getName() + "/" + super.getParent().getName() + "/" + this.getUrl();
    }

    public MethodResultException getException() {
        return this.exception;
    }

    public void setException(MethodResultException exception) {
        this.exception = exception;
    }

    public String getUrl() {
        String url = this.getName();
        if (this.testUuid != null) {
            url = url + "_" + this.testUuid;
        }
        return url;
    }

    @Exported
    public long getDuration() {
        return this.duration;
    }

    @Exported(visibility=9)
    public String getStatus() {
        return this.status;
    }

    @Exported
    public String getDescription() {
        return this.description;
    }

    @Exported
    public List<String> getGroups() {
        return this.groups;
    }

    @Exported
    public List<String> getParameters() {
        return this.parameters;
    }

    @Exported(name="exception")
    public String getExceptionString() {
        if (this.exception != null) {
            return this.exception.toString();
        }
        return null;
    }

    @Exported(name="className")
    public String getClassName() {
        return this.getParent().getName();
    }

    public void setGroups(List<String> groups) {
        this.groups = groups;
    }

    public void setParameters(List<String> parameters) {
        this.parameters = parameters;
    }

    public String getDisplayDescription() {
        TestNGProjectAction projAction = (TestNGProjectAction)super.getOwner().getProject().getAction(TestNGProjectAction.class);
        if (projAction.getEscapeTestDescp()) {
            return FormatUtil.escapeString((String)this.description);
        }
        return this.description;
    }

    public String getDisplayExceptionMessage() {
        TestNGProjectAction projAction = (TestNGProjectAction)super.getOwner().getProject().getAction(TestNGProjectAction.class);
        if (projAction.getEscapeExceptionMsg()) {
            return FormatUtil.escapeString((String)this.exception.getMessage());
        }
        return this.exception.getMessage();
    }

    public String getDisplayDuration() {
        return FormatUtil.formatTimeInMilliSeconds((long)this.duration);
    }

    public String getDisplayGroups() {
        if (this.groups != null && !this.groups.isEmpty()) {
            return StringUtils.join((Collection)this.groups, (String)", ");
        }
        return "";
    }

    public boolean isConfig() {
        return this.isConfig;
    }

    public void doGraph(StaplerRequest req, StaplerResponse rsp) throws IOException {
        Graph g = this.getGraph(req, rsp);
        if (g != null) {
            g.doPng(req, rsp);
        }
    }

    public void doGraphMap(StaplerRequest req, StaplerResponse rsp) throws IOException {
        Graph g = this.getGraph(req, rsp);
        if (g != null) {
            g.doMap(req, rsp);
        }
    }

    private Graph getGraph(StaplerRequest req, StaplerResponse rsp) {
        Calendar t = ((AbstractBuild)this.getOwner().getProject().getLastCompletedBuild()).getTimestamp();
        if (req.checkIfModified(t, rsp)) {
            return null;
        }
        DataSetBuilder dataSetBuilder = new DataSetBuilder();
        HashMap statusMap = new HashMap();
        this.populateDataSetBuilder(dataSetBuilder, statusMap);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private void populateDataSetBuilder(DataSetBuilder<String, ChartUtil.NumberOnlyBuildLabel> dataSetBuilder, Map<ChartUtil.NumberOnlyBuildLabel, String> statusMap) {
        AbstractBuild build;
        int count = 0;
        for (build = this.getOwner(); build != null; build = (AbstractBuild)build.getNextBuild()) {
            this.addData(dataSetBuilder, statusMap, build);
        }
        for (build = this.getOwner(); build != null && count++ < 10; build = (AbstractBuild)build.getPreviousBuild()) {
            this.addData(dataSetBuilder, statusMap, build);
        }
    }

    private void addData(DataSetBuilder<String, ChartUtil.NumberOnlyBuildLabel> dataSetBuilder, Map<ChartUtil.NumberOnlyBuildLabel, String> statusMap, AbstractBuild<?, ?> build) {
        ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(build);
        TestNGBuildAction action = (TestNGBuildAction)build.getAction(TestNGBuildAction.class);
        TestResults results = null;
        MethodResult methodResult = null;
        if (action != null && (results = action.getResults()) != null) {
            methodResult = this.getMethodResult(results);
        }
        if (methodResult == null) {
            dataSetBuilder.add((Number)0, (Comparable)((Object)"resultRow"), (Comparable)label);
            statusMap.put(label, "UNKNOWN");
        } else {
            dataSetBuilder.add((Number)(methodResult.getDuration() / 1000L), (Comparable)((Object)"resultRow"), (Comparable)label);
            statusMap.put(label, methodResult.getStatus());
        }
    }

    private MethodResult getMethodResult(TestResults results) {
        Map packageMap = results.getPackageMap();
        String methodPackageName = this.getParent().getParent().getName();
        String methodClassName = this.getParent().getName();
        if (packageMap.containsKey(methodPackageName) && ((PackageResult)packageMap.get(methodPackageName)).getClassList() != null) {
            List classResults = ((PackageResult)packageMap.get(methodPackageName)).getClassList();
            for (ClassResult classResult : classResults) {
                if (!classResult.getName().equals(methodClassName)) continue;
                List methodResults = null;
                methodResults = this.isConfig ? classResult.getConfigurationMethods() : classResult.getTestMethods();
                if (methodResults == null) continue;
                for (MethodResult methodResult : methodResults) {
                    if (!methodResult.getUrl().equals(this.getUrl())) continue;
                    return methodResult;
                }
            }
        }
        return null;
    }

    public Object getCssClass() {
        if (this.status != null) {
            if (this.status.equalsIgnoreCase("pass")) {
                return "result-passed";
            }
            if (this.status.equalsIgnoreCase("skip")) {
                return "result-skipped";
            }
            if (this.status.equalsIgnoreCase("fail")) {
                return "result-failed";
            }
        }
        return "result-passed";
    }
}

