/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testng.results;

import hudson.model.AbstractBuild;
import hudson.plugins.testng.results.BaseResult;
import hudson.plugins.testng.results.ClassResult;
import hudson.plugins.testng.results.MethodResult;
import hudson.plugins.testng.results.TestResults;
import hudson.plugins.testng.util.FormatUtil;
import hudson.plugins.testng.util.TestResultHistoryUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.bind.JavaScriptMethod;
import org.kohsuke.stapler.export.Exported;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageResult
extends BaseResult {
    private List<ClassResult> classList = new ArrayList();
    private List<MethodResult> sortedTestMethodsByStartTime = null;
    private transient long duration;
    private transient int fail;
    private transient int skip;
    private transient int total;
    public final int MAX_EXEC_MTHD_LIST_SIZE = 25;

    public PackageResult(String name) {
        super(name);
    }

    public void setOwner(AbstractBuild<?, ?> owner) {
        super.setOwner(owner);
        for (ClassResult _class : this.classList) {
            _class.setOwner(owner);
        }
    }

    @Exported(name="classs")
    public List<ClassResult> getClassList() {
        return this.classList;
    }

    @Exported
    public long getDuration() {
        return this.duration;
    }

    @Exported(visibility=9)
    public int getFail() {
        return this.fail;
    }

    @Exported(visibility=9)
    public int getSkip() {
        return this.skip;
    }

    @Exported(visibility=9)
    public int getTotal() {
        return this.total;
    }

    public long getAge() {
        PackageResult packageResult = this.getPreviousPackageResult();
        if (packageResult == null) {
            return 1L;
        }
        return 1L + packageResult.getAge();
    }

    public List<MethodResult> getSortedTestMethodsByStartTime() {
        if (this.sortedTestMethodsByStartTime == null) {
            this.sortTestMethods();
        }
        return this.sortedTestMethodsByStartTime;
    }

    @JavaScriptMethod
    public String getAllSortedTestMethodsByStartTime() {
        return this.getMethodExecutionTableContent(this.getSortedTestMethodsByStartTime());
    }

    @JavaScriptMethod
    public String getFirstXSortedTestMethodsByStartTime() {
        List list;
        list = list.subList(0, (list = this.getSortedTestMethodsByStartTime()).size() > 25 ? 25 : list.size());
        return this.getMethodExecutionTableContent(list);
    }

    private String getMethodExecutionTableContent(List<MethodResult> mrList) {
        StringBuffer sb = new StringBuffer(mrList.size() * 100);
        for (MethodResult mr : mrList) {
            sb.append("<tr><td align=\"left\">");
            sb.append("<a href=\"../").append(mr.getFullUrl()).append("\">");
            sb.append(mr.getParent().getName()).append(".").append(mr.getName());
            sb.append("</a>");
            sb.append("</td><td align=\"center\">");
            sb.append(FormatUtil.formatTimeInMilliSeconds((long)mr.getDuration()));
            sb.append("</td><td align=\"center\">");
            sb.append(mr.getStartedAt());
            sb.append("</td><td align=\"center\"><span class=\"").append(mr.getCssClass()).append("\">");
            sb.append(mr.getStatus());
            sb.append("</span></td></tr>");
        }
        return sb.toString();
    }

    public void tally() {
        this.duration = 0L;
        this.fail = 0;
        this.skip = 0;
        this.total = 0;
        for (ClassResult _c : this.classList) {
            _c.setParent((BaseResult)this);
            _c.tally();
            this.duration += _c.getDuration();
            this.fail += _c.getFail();
            this.skip += _c.getSkip();
            this.total += _c.getTotal();
        }
    }

    public Object getDynamic(String token, StaplerRequest req, StaplerResponse rsp) {
        if (token.equals("/" + this.getName())) {
            return this;
        }
        ClassResult result = null;
        for (ClassResult _c : this.classList) {
            if (!_c.getName().equals(token)) continue;
            result = _c;
            break;
        }
        return result;
    }

    public void sortTestMethods() {
        this.sortedTestMethodsByStartTime = new ArrayList();
        HashMap map = new HashMap();
        for (ClassResult aClass : this.classList) {
            if (aClass.getTestMethods() == null) continue;
            for (MethodResult aMethod : aClass.getTestMethods()) {
                Date startDate = aMethod.getStartedAt();
                if (aMethod.getStatus().equalsIgnoreCase("skip") || startDate == null) continue;
                if (map.containsKey(startDate)) {
                    ((List)map.get(startDate)).add(aMethod);
                    continue;
                }
                ArrayList<MethodResult> list = new ArrayList<MethodResult>();
                list.add(aMethod);
                map.put(startDate, list);
            }
        }
        ArrayList keys = new ArrayList(map.keySet());
        Collections.sort(keys);
        for (Date key : keys) {
            if (!map.containsKey(key)) continue;
            this.sortedTestMethodsByStartTime.addAll((Collection)map.get(key));
        }
    }

    private PackageResult getPreviousPackageResult() {
        TestResults previousTestResult = TestResultHistoryUtil.getPreviousBuildTestResults((AbstractBuild)this.getOwner());
        Map previousPackageMap = previousTestResult.getPackageMap();
        for (Map.Entry entry : previousPackageMap.entrySet()) {
            if (!((String)entry.getKey()).equals(this.getName())) continue;
            return (PackageResult)entry.getValue();
        }
        return null;
    }

    public long getFailedTestsDiffCount() {
        PackageResult prevPackageResult = this.getPreviousPackageResult();
        if (prevPackageResult != null) {
            return this.fail - prevPackageResult.getFail();
        }
        return 0L;
    }

    public long getTotalTestsDiffCount() {
        PackageResult prevPackageResult = this.getPreviousPackageResult();
        if (prevPackageResult != null) {
            return this.total - prevPackageResult.getTotal();
        }
        return 0L;
    }

    public long getSkippedTestsDiffCount() {
        PackageResult prevPackageResult = this.getPreviousPackageResult();
        if (prevPackageResult != null) {
            return this.skip - prevPackageResult.getSkip();
        }
        return 0L;
    }
}

