/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testng.results;

import hudson.model.AbstractBuild;
import hudson.plugins.testng.results.BaseResult;
import hudson.plugins.testng.results.ClassResult;
import hudson.plugins.testng.results.MethodResult;
import hudson.plugins.testng.results.PackageResult;
import hudson.plugins.testng.results.TestResult;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestResults
extends BaseResult
implements Serializable {
    private static final long serialVersionUID = -3491974223665601995L;
    private List<TestResult> testList = new ArrayList();
    private List<MethodResult> passedTests = new ArrayList();
    private List<MethodResult> failedTests = new ArrayList();
    private List<MethodResult> skippedTests = new ArrayList();
    private List<MethodResult> failedConfigurationMethods = new ArrayList();
    private List<MethodResult> skippedConfigurationMethods = new ArrayList();
    private long duration;
    private int totalTestCount;
    private int passedTestCount;
    private int failedTestCount;
    private int skippedTestCount;
    private int failedConfigurationMethodsCount;
    private int skippedConfigurationMethodsCount;
    private Map<String, PackageResult> packageMap = new HashMap();

    public TestResults(String name) {
        super(name);
    }

    public List<MethodResult> getFailedTests() {
        return this.failedTests;
    }

    public List<MethodResult> getPassedTests() {
        return this.passedTests;
    }

    public List<MethodResult> getSkippedTests() {
        return this.skippedTests;
    }

    public List<MethodResult> getFailedConfigs() {
        return this.failedConfigurationMethods;
    }

    public List<MethodResult> getSkippedConfigs() {
        return this.skippedConfigurationMethods;
    }

    public List<TestResult> getTestList() {
        return this.testList;
    }

    @Exported(name="total")
    public int getTotalTestCount() {
        return this.totalTestCount;
    }

    @Exported
    public long getDuration() {
        return this.duration;
    }

    public int getPassedTestCount() {
        return this.passedTestCount;
    }

    @Exported(name="fail")
    public int getFailedTestCount() {
        return this.failedTestCount;
    }

    @Exported(name="skip")
    public int getSkippedTestCount() {
        return this.skippedTestCount;
    }

    @Exported(name="fail-config")
    public int getFailedConfigCount() {
        return this.failedConfigurationMethodsCount;
    }

    @Exported(name="skip-config")
    public int getSkippedConfigCount() {
        return this.skippedConfigurationMethodsCount;
    }

    @Exported(name="package")
    public Collection<PackageResult> getPackageList() {
        return this.packageMap.values();
    }

    public Map<String, PackageResult> getPackageMap() {
        return this.packageMap;
    }

    public Set<String> getPackageNames() {
        return this.packageMap.keySet();
    }

    public void addUniqueTests(List<TestResult> testList) {
        HashSet<TestResult> tmpSet = new HashSet<TestResult>(this.testList);
        tmpSet.addAll(testList);
        this.testList = new ArrayList(tmpSet);
    }

    public void setOwner(AbstractBuild<?, ?> owner) {
        this.owner = owner;
        for (TestResult _test : this.testList) {
            _test.setOwner(owner);
        }
        for (PackageResult pkg : this.packageMap.values()) {
            pkg.setOwner(owner);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestResults testResults = (TestResults)o;
        return this.name.equals(testResults.name) && !(this.owner == null ? testResults.owner != null : !this.owner.equals(testResults.owner));
    }

    public int hashCode() {
        int result = this.owner != null ? this.owner.hashCode() : 0;
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public String toString() {
        return String.format("TestResults {name='%s', totalTests=%d, failedTests=%d, skippedTests=%d, failedConfigs=%d, skippedConfigs=%d}", this.name, this.totalTestCount, this.failedTestCount, this.skippedTestCount, this.failedConfigurationMethodsCount, this.skippedConfigurationMethodsCount);
    }

    public void tally() {
        this.failedConfigurationMethodsCount = this.failedConfigurationMethods.size();
        this.skippedConfigurationMethodsCount = this.skippedConfigurationMethods.size();
        this.failedTestCount = this.failedTests.size();
        this.passedTestCount = this.passedTests.size();
        this.skippedTestCount = this.skippedTests.size();
        this.totalTestCount = this.passedTestCount + this.failedTestCount + this.skippedTestCount;
        this.packageMap.clear();
        for (TestResult _test : this.testList) {
            for (ClassResult _class : _test.getClassList()) {
                String pkg = _class.getName();
                int lastDot = pkg.lastIndexOf(46);
                pkg = lastDot == -1 ? "No Package" : pkg.substring(0, lastDot);
                if (this.packageMap.containsKey(pkg)) {
                    List classResults = ((PackageResult)this.packageMap.get(pkg)).getClassList();
                    if (classResults.contains(_class)) continue;
                    classResults.add(_class);
                    continue;
                }
                PackageResult tpkg = new PackageResult(pkg);
                tpkg.getClassList().add(_class);
                tpkg.setParent((BaseResult)this);
                this.packageMap.put(pkg, tpkg);
            }
        }
        this.duration = 0L;
        for (PackageResult pkgResult : this.packageMap.values()) {
            pkgResult.tally();
            this.duration += pkgResult.getDuration();
        }
    }

    public Object getDynamic(String token, StaplerRequest req, StaplerResponse rsp) {
        return this.packageMap.get(token);
    }
}

