/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testng.util;

import hudson.model.AbstractBuild;
import hudson.plugins.testng.TestNGBuildAction;
import hudson.plugins.testng.TestNGProjectAction;
import hudson.plugins.testng.results.ClassResult;
import hudson.plugins.testng.results.MethodResult;
import hudson.plugins.testng.results.TestResults;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class TestResultHistoryUtil {
    public static TestResults getPreviousBuildTestResults(AbstractBuild<?, ?> owner) {
        AbstractBuild previousBuild = (AbstractBuild)owner.getPreviousBuild();
        if (previousBuild != null && previousBuild.getAction(TestNGBuildAction.class) != null) {
            return ((TestNGBuildAction)previousBuild.getAction(TestNGBuildAction.class)).getResults();
        }
        return new TestResults("");
    }

    public static String toSummary(TestNGBuildAction action) {
        int prevFailedTestCount = 0;
        int prevSkippedTestCount = 0;
        int prevFailedConfigurationCount = 0;
        int prevSkippedConfigurationCount = 0;
        int prevTotalTestCount = 0;
        AbstractBuild owner = action.getBuild();
        TestResults previousResult = TestResultHistoryUtil.getPreviousBuildTestResults((AbstractBuild)owner);
        prevFailedTestCount = previousResult.getFailedTestCount();
        prevSkippedTestCount = previousResult.getSkippedTestCount();
        prevFailedConfigurationCount = previousResult.getFailedConfigCount();
        prevSkippedConfigurationCount = previousResult.getSkippedConfigCount();
        prevTotalTestCount = previousResult.getTotalTestCount();
        TestResults tr = action.getResults();
        return "<ul>" + TestResultHistoryUtil.diff((long)prevTotalTestCount, (long)tr.getTotalTestCount(), (String)"Total Tests") + TestResultHistoryUtil.diff((long)prevFailedTestCount, (long)tr.getFailedTestCount(), (String)"Failed Tests") + TestResultHistoryUtil.printTestsUrls((AbstractBuild)owner, (List)tr.getFailedTests()) + TestResultHistoryUtil.diff((long)prevSkippedTestCount, (long)tr.getSkippedTestCount(), (String)"Skipped Tests") + TestResultHistoryUtil.printTestsUrls((AbstractBuild)owner, (List)tr.getSkippedTests()) + TestResultHistoryUtil.diff((long)prevFailedConfigurationCount, (long)tr.getFailedConfigCount(), (String)"Failed Configurations") + TestResultHistoryUtil.printTestsUrls((AbstractBuild)owner, (List)tr.getFailedConfigs()) + TestResultHistoryUtil.diff((long)prevSkippedConfigurationCount, (long)tr.getSkippedConfigCount(), (String)"Skipped Configurations") + TestResultHistoryUtil.printTestsUrls((AbstractBuild)owner, (List)tr.getSkippedConfigs()) + "</ul>";
    }

    private static String diff(long prev, long curr, String name) {
        if (prev <= curr) {
            return "<li>" + name + ": " + curr + " (+" + (curr - prev) + ")</li>";
        }
        return "<li>" + name + ": " + curr + " (-" + (prev - curr) + ")</li>";
    }

    private static String printTestsUrls(AbstractBuild<?, ?> owner, List<MethodResult> methodResults) {
        StringBuffer htmlStr = new StringBuffer();
        htmlStr.append("<OL>");
        if (methodResults != null && methodResults.size() > 0) {
            for (MethodResult methodResult : methodResults) {
                htmlStr.append("<LI>");
                if (methodResult.getParent() instanceof ClassResult) {
                    htmlStr.append("<a href=\"").append(owner.getUpUrl());
                    htmlStr.append(owner.getNumber());
                    htmlStr.append("/").append(((TestNGProjectAction)owner.getProject().getAction(TestNGProjectAction.class)).getUrlName());
                    htmlStr.append("/").append(methodResult.getFullUrl());
                    htmlStr.append("\">");
                    htmlStr.append(((ClassResult)methodResult.getParent()).getName());
                    htmlStr.append(".").append(methodResult.getName()).append("</a>");
                } else {
                    htmlStr.append(methodResult.getName());
                }
                htmlStr.append("</LI>");
            }
        }
        htmlStr.append("</OL>");
        return htmlStr.substring(0);
    }
}

