/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.translation;

import com.sun.mail.util.BASE64EncoderStream;
import hudson.Extension;
import hudson.Util;
import hudson.model.Hudson;
import hudson.model.PageDecorator;
import hudson.plugins.translation.ContributedL10nStore;
import hudson.plugins.translation.L10nDecorator;
import hudson.plugins.translation.Locales;
import hudson.plugins.translation.Msg;
import hudson.plugins.translation.MsgRecorder;
import hudson.plugins.translation.ResourceBundleFactoryImpl;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.WebApp;
import org.kohsuke.stapler.jelly.InternationalizedStringExpressionListener;
import org.kohsuke.stapler.jelly.JellyFacet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class L10nDecorator
extends PageDecorator {
    public final ContributedL10nStore store = new ContributedL10nStore();
    private final ResourceBundleFactoryImpl bundleFactory = new ResourceBundleFactoryImpl(this.store);
    private final Hudson hudson = Hudson.getInstance();

    public L10nDecorator() {
        super(L10nDecorator.class);
        ((JellyFacet)WebApp.get((ServletContext)this.hudson.servletContext).getFacet(JellyFacet.class)).resourceBundleFactory = this.bundleFactory;
    }

    public List<Locales.Entry> listLocales() {
        return Locales.LIST;
    }

    public void startRecording(StaplerRequest request) {
        request.setAttribute(InternationalizedStringExpressionListener.class.getName(), (Object)new MsgRecorder());
    }

    public Collection<Msg> getRecording(StaplerRequest request) {
        return ((MsgRecorder)request.getAttribute((String)InternationalizedStringExpressionListener.class.getName())).set;
    }

    public String encodeRecording(StaplerRequest request) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream w = new PrintStream(new GZIPOutputStream(new CipherOutputStream((OutputStream)baos, this.getCipher(1))));
        for (Msg e : this.getRecording(request)) {
            w.println(e.resourceBundle.getBaseName());
            w.println(e.key);
        }
        w.close();
        return new String(Base64.encodeBase64((byte[])baos.toByteArray()));
    }

    public List<Msg> decode(StaplerRequest request) throws IOException, DecoderException {
        String s;
        BufferedReader r = new BufferedReader(new InputStreamReader(new GZIPInputStream(new CipherInputStream(new ByteArrayInputStream(Base64.decodeBase64((String)request.getParameter("bundles"))), this.getCipher(2)))));
        ArrayList<Msg> l = new ArrayList<Msg>();
        while ((s = r.readLine()) != null) {
            l.add(new Msg(this.bundleFactory.create(s), r.readLine()));
        }
        return l;
    }

    private Cipher getCipher(int mode) {
        try {
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(mode, this.hudson.getSecretKeyAsAES128());
            return cipher;
        }
        catch (GeneralSecurityException e) {
            throw new Error(e);
        }
    }

    public String getPrimaryTranslationLocale(StaplerRequest req) {
        String lang = req.getHeader("Accept-Language");
        if (lang == null) {
            return null;
        }
        for (String t : lang.split(",")) {
            int idx = t.indexOf(59);
            if (idx >= 0) {
                t = t.substring(0, idx);
            }
            t = t.replace('-', '_').toLowerCase(Locale.ENGLISH);
            for (Locales.Entry e : Locales.LIST) {
                if (!t.equals(e.lcode)) continue;
                return e.lcode;
            }
            for (Locales.Entry e : Locales.LIST) {
                if (!t.startsWith(e.lcode)) continue;
                return e.lcode;
            }
        }
        return null;
    }

    public void doSubmit(StaplerRequest req, StaplerResponse rsp, @QueryParameter String locale) throws IOException, ServletException {
        JSONObject json = req.getSubmittedForm();
        if (this.hudson.hasPermission(Hudson.ADMINISTER)) {
            HashMap<String, Properties> updates = new HashMap<String, Properties>();
            for (SubmissionEntry submissionEntry : req.bindJSONToList(SubmissionEntry.class, json.get("entry"))) {
                if (!submissionEntry.isUpdated()) continue;
                Properties p = (Properties)updates.get(submissionEntry.baseName);
                if (p == null) {
                    p = new Properties();
                    this.store.loadTo(locale, submissionEntry.baseName, p);
                    updates.put(submissionEntry.baseName, p);
                }
                p.put(submissionEntry.key, submissionEntry.text);
            }
            for (Map.Entry entry : updates.entrySet()) {
                this.store.save(locale, (String)entry.getKey(), (Properties)entry.getValue());
            }
            this.bundleFactory.clearCache();
        }
        json.remove("bundles");
        json.put((Object)"id", (Object)UUID.randomUUID().toString());
        json.put((Object)"installation", (Object)Util.getDigestOf((String)this.hudson.getSecretKey()));
        json.put((Object)"version", (Object)Hudson.VERSION);
        rsp.setContentType("text/plain;charset=UTF-8");
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)new GZIPOutputStream((OutputStream)new BASE64EncoderStream((OutputStream)rsp.getOutputStream())), "UTF-8");
        json.write((Writer)w);
        w.close();
        rsp.setStatus(200);
    }
}

