/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.translation;

import hudson.Util;
import hudson.model.Hudson;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ContributedL10nStore {
    private final Hudson hudson = Hudson.getInstance();
    private static final Pattern JSP_LOADER_PATTERN = Pattern.compile("generated/jsp/(.+)/loader/");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadTo(String locale, String baseName, Properties props) {
        File d = this.getDir(locale);
        if (!d.exists()) {
            return;
        }
        File f = new File(d, Util.getDigestOf((String)this.trim(baseName)));
        if (!f.exists() && !(f = new File(d, Util.getDigestOf((String)baseName))).exists()) {
            return;
        }
        Properties override = new Properties();
        try {
            FileInputStream in = new FileInputStream(f);
            try {
                override.load(in);
            }
            finally {
                in.close();
            }
        }
        catch (IOException e) {
            f.delete();
        }
        props.putAll((Map<?, ?>)override);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String locale, String baseName, Properties props) throws IOException {
        File d = this.getDir(locale);
        if (!d.exists()) {
            d.mkdirs();
        }
        File f = new File(d, Util.getDigestOf((String)this.trim(baseName)));
        FileOutputStream out = new FileOutputStream(f);
        try {
            props.store(out, null);
        }
        finally {
            out.close();
        }
    }

    private String trim(String baseName) {
        int idx;
        if (baseName.startsWith("file:")) {
            idx = baseName.lastIndexOf("WEB-INF/classes");
            if (idx >= 0) {
                return baseName.substring(idx + "WEB-INF/classes".length());
            }
            Matcher m = JSP_LOADER_PATTERN.matcher(baseName);
            if (m.find()) {
                return baseName.substring(m.end() - 1);
            }
        }
        if (baseName.startsWith("jar:")) {
            idx = baseName.lastIndexOf("!");
            return baseName.substring(idx + 1);
        }
        return baseName;
    }

    private File getDir(String locale) {
        return new File(this.hudson.getRootDir(), "contributed-localizations/" + locale);
    }
}

