/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.translation;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.kohsuke.stapler.Stapler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Locales {
    public static final List<Entry> LIST = Locales.convert("Afrikaans", "af", "Albanian", "sq", "Arabic", "ar", "Basque", "eu", "Belarusian", "be", "Bengali (India)", "bn_IN", "Bulgarian", "bg", "Catalan", "ca", "Chinese (Simplified)", "zh_CN", "Chinese (Traditional)", "zh_TW", "Czech", "cs", "Danish", "da", "Dutch", "nl", "English (British)", "en_GB", "Esperanto", "eo", "Estonian", "et", "Faroese", "fo", "Finnish", "fi", "French", "fr", "Frisian", "fy_NL", "Galician", "gl", "Georgian", "ka", "German", "de", "Greek", "el", "Gujarati", "gu_IN", "Hebrew", "he", "Hindi", "hi_IN", "Hungarian", "hu", "Icelandic", "is", "Indonesian", "id", "Irish", "ga_IE", "Italian", "it", "Japanese", "ja", "Kannada", "kn", "Korean", "ko", "Kurdish", "ku", "Latvian", "lv", "Lithuanian", "lt", "Macedonian", "mk", "Marathi", "mr", "Mongolian", "mn", "Norwegian (Bokm\u00e5l)", "nb_NO", "Norwegian (Lengadocian)", "nn_NO", "Occitan (Lengadocian)", "oc", "Polish", "pl", "Portuguese (Brazilian)", "pt_BR", "Portuguese (Portugal)", "pt_PT", "Punjabi", "pa_IN", "Romanian", "ro", "Russian", "ru", "Serbian", "sr", "Sinhala", "si", "Slovak", "sk", "Slovenian", "sl", "Spanish", "es", "Spanish (Argentina)", "es_AR", "Swedish", "sv_SE", "Tamil", "ta", "Telgu", "te", "Thai", "th", "Turkish", "tr", "Ukrainian", "uk");

    private static List<Entry> convert(String ... args) {
        ArrayList<Entry> r = new ArrayList<Entry>();
        for (int i = 0; i < args.length; i += 2) {
            r.add(new Entry(args[i], args[i + 1]));
        }
        return r;
    }

    public static final class Entry {
        public final String name;
        public final String code;
        public final String lcode;
        public final Locale locale;

        public Entry(String name, String code) {
            this.name = name;
            this.code = code;
            this.lcode = code.toLowerCase(Locale.ENGLISH);
            String[] tokens = code.split("_");
            this.locale = tokens.length == 1 ? new Locale(tokens[0]) : new Locale(tokens[0], tokens[1]);
        }

        public boolean matchesRequestLocale() {
            return Stapler.getCurrentRequest().getLocale().toString().equals(this.code);
        }
    }
}

