/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.translation;

import java.util.Locale;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.jelly.InternationalizedStringExpression;
import org.kohsuke.stapler.jelly.ResourceBundle;

public final class Msg {
    public final ResourceBundle resourceBundle;
    public final String key;

    public Msg(InternationalizedStringExpression exp) {
        this.resourceBundle = exp.resourceBundle;
        this.key = exp.key;
    }

    public Msg(ResourceBundle resourceBundle, String key) {
        this.resourceBundle = resourceBundle;
        this.key = key;
    }

    public String getBaseName() {
        return this.resourceBundle.getBaseName();
    }

    public String getEnglish() {
        String msg = this.resourceBundle.getFormatString(Locale.ENGLISH, this.key);
        if (msg == null) {
            msg = this.key;
        }
        return msg;
    }

    public String getLocalizedText() {
        return this.resourceBundle.getFormatStringWithoutDefaulting(Stapler.getCurrentRequest().getLocale(), this.key);
    }

    public boolean isLocalized() {
        return this.getLocalizedText() != null;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Msg that = (Msg)o;
        return this.key.equals(that.key) && that.resourceBundle.equals((Object)that.resourceBundle);
    }

    public int hashCode() {
        return this.resourceBundle.hashCode() * 31 + this.key.hashCode();
    }
}

