/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.translation;

import hudson.plugins.translation.ContributedL10nStore;
import java.util.Properties;
import org.kohsuke.stapler.jelly.ResourceBundle;
import org.kohsuke.stapler.jelly.ResourceBundleFactory;

final class ResourceBundleFactoryImpl
extends ResourceBundleFactory {
    private final ContributedL10nStore store;
    private volatile int reloadModCount = 0;

    ResourceBundleFactoryImpl(ContributedL10nStore store) {
        this.store = store;
    }

    public ResourceBundle create(String baseName) {
        return new ResourceBundle(baseName){
            private int modCount;
            {
                this.modCount = ResourceBundleFactoryImpl.this.reloadModCount;
            }

            protected Properties wrapUp(String locale, Properties props) {
                ResourceBundleFactoryImpl.this.store.loadTo(locale, this.getBaseName(), props);
                return props;
            }

            protected Properties get(String key) {
                int mc = ResourceBundleFactoryImpl.this.reloadModCount;
                if (this.modCount != mc) {
                    this.clearCache();
                    this.modCount = mc;
                }
                return super.get(key);
            }
        };
    }

    public void clearCache() {
        ++this.reloadModCount;
    }
}

