/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.violations;

import hudson.FilePath;
import hudson.plugins.violations.TypeConfig;
import hudson.plugins.violations.TypeDescriptor;
import hudson.plugins.violations.TypeSummary;
import hudson.plugins.violations.ViolationsConfig;
import hudson.plugins.violations.ViolationsReport;
import hudson.plugins.violations.generate.GenerateXML;
import hudson.plugins.violations.model.FullBuildModel;
import hudson.plugins.violations.model.FullFileModel;
import hudson.plugins.violations.model.Violation;
import hudson.plugins.violations.util.StringUtil;
import hudson.remoting.VirtualChannel;
import hudson.util.IOException2;
import java.io.File;
import java.io.IOException;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViolationsCollector
implements FilePath.FileCallable<ViolationsReport> {
    private static final Logger LOG = Logger.getLogger(ViolationsCollector.class.getName());
    private static final String[] NO_STRINGS = new String[0];
    private final boolean mavenProject;
    private final FilePath targetDir;
    private final FilePath htmlDir;
    private final ViolationsConfig config;
    private FullBuildModel model;
    private File workspace;
    private static final long serialVersionUID = 1L;

    public ViolationsCollector(boolean mavenProject, FilePath targetDir, FilePath htmlDir, ViolationsConfig config) {
        this.mavenProject = mavenProject;
        this.targetDir = targetDir;
        this.htmlDir = htmlDir;
        this.config = config;
    }

    private boolean empty(String str) {
        return str == null || str.equals("");
    }

    public ViolationsReport invoke(File workspace, VirtualChannel channel) throws IOException {
        this.workspace = workspace;
        if (!StringUtil.isBlank((String)this.config.getFauxProjectPath())) {
            this.workspace = new File(this.config.getFauxProjectPath());
            LOG.fine("Using faux workspace " + this.workspace);
        }
        String[] sourcePaths = null;
        sourcePaths = this.mavenProject ? new String[]{workspace.toString() + "/src/main/java"} : this.findAbsoluteDirs(workspace, this.config.getSourcePathPattern());
        for (String sp : sourcePaths) {
            LOG.fine("Using extra sourcePath " + sp);
        }
        ViolationsReport report = new ViolationsReport();
        report.setConfig(this.config);
        this.model = new FullBuildModel();
        for (String type : this.config.getTypeConfigs().keySet()) {
            TypeConfig c = (TypeConfig)this.config.getTypeConfigs().get(type);
            TypeDescriptor typeDescriptor = (TypeDescriptor)TypeDescriptor.TYPES.get(type);
            if (typeDescriptor == null) continue;
            if (this.mavenProject && typeDescriptor.getMavenTargets() != null) {
                this.doType(c, typeDescriptor, sourcePaths, report);
                continue;
            }
            if (this.empty(c.getPattern())) continue;
            this.doType(c, typeDescriptor, sourcePaths, report);
        }
        this.model.cleanup();
        try {
            new GenerateXML(this.targetDir, this.model, this.config).execute();
        }
        catch (InterruptedException ex) {
            throw new IOException2((Throwable)ex);
        }
        for (String type : this.model.getTypeMap().keySet()) {
            report.getViolations().put(type, this.model.getCountNumber(type));
            this.doSeverities(report, type);
        }
        return report;
    }

    private void doSeverities(ViolationsReport report, String type) {
        TypeSummary summary = report.getTypeSummary(type);
        for (FullFileModel file : this.model.getFileModelMap().values()) {
            if (file.getTypeMap().get(type) == null) continue;
            for (Violation v : (TreeSet)file.getTypeMap().get(type)) {
                int[] nArray = summary.getSeverityArray();
                int n = v.getSeverityLevel();
                nArray[n] = nArray[n] + 1;
            }
        }
    }

    private void doType(TypeConfig c, TypeDescriptor t, String[] sourcePaths, ViolationsReport report) throws IOException {
        String[] fileNames = null;
        if (this.mavenProject && t.getMavenTargets() != null && !c.isUsePattern()) {
            for (String name : t.getMavenTargets()) {
                fileNames = this.findFiles(this.workspace, "target/" + name);
                if (fileNames.length == 0) continue;
                break;
            }
            if (fileNames.length == 0) {
                return;
            }
        } else {
            fileNames = this.findFiles(this.workspace, c.getPattern());
            if (fileNames.length == 0) {
                if (!this.mavenProject) {
                    report.getViolations().put(c.getType(), -1);
                    report.getTypeSummary(c.getType()).setErrorMessage("No violation report files of type " + c.getType() + " with pattern " + c.getPattern() + " were found!");
                }
                return;
            }
        }
        this.model.addType(c.getType());
        for (String fileName : fileNames) {
            t.createParser().parse(this.model, this.workspace, fileName, sourcePaths);
        }
    }

    private String[] findFiles(File workspaceRoot, String pattern) {
        if (StringUtil.isBlank((String)pattern)) {
            return NO_STRINGS;
        }
        FileSet fileSet = new FileSet();
        Project project = new Project();
        fileSet.setProject(project);
        fileSet.setDir(workspaceRoot);
        fileSet.setIncludes(pattern);
        return fileSet.getDirectoryScanner(project).getIncludedFiles();
    }

    private String[] findDirs(File workspaceRoot, String pattern) {
        if (StringUtil.isBlank((String)pattern)) {
            return NO_STRINGS;
        }
        FileSet fileSet = new FileSet();
        Project project = new Project();
        fileSet.setProject(project);
        fileSet.setDir(workspaceRoot);
        fileSet.setIncludes(pattern);
        return fileSet.getDirectoryScanner(project).getIncludedDirectories();
    }

    private String[] findAbsoluteDirs(File workspaceRoot, String pattern) {
        String[] relative = this.findDirs(workspaceRoot, pattern);
        if (relative.length == 0) {
            return relative;
        }
        String[] absolute = new String[relative.length];
        for (int i = 0; i < relative.length; ++i) {
            absolute[i] = new File(workspaceRoot, relative[i]).getAbsolutePath();
        }
        return absolute;
    }
}

