/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.violations;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.plugins.violations.ViolationsBuildAction;
import hudson.plugins.violations.ViolationsCollector;
import hudson.plugins.violations.ViolationsConfig;
import hudson.plugins.violations.ViolationsProjectAction;
import hudson.plugins.violations.ViolationsReport;
import hudson.plugins.violations.hudson.ViolationsFreestyleDescriptor;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import java.io.File;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViolationsPublisher
extends Recorder {
    private static final String VIOLATIONS = "violations";
    private final ViolationsConfig config = new ViolationsConfig();
    @Extension
    public static final BuildStepDescriptor<Publisher> DESCRIPTOR = new ViolationsFreestyleDescriptor();

    public ViolationsConfig getConfig() {
        return this.config;
    }

    public ViolationsConfig getOldConfig() {
        return this.config.clone();
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        FilePath htmlPath = new FilePath(new File(build.getProject().getRootDir(), VIOLATIONS));
        FilePath targetPath = new FilePath(new File(build.getRootDir(), VIOLATIONS));
        ViolationsReport report = (ViolationsReport)build.getWorkspace().act((FilePath.FileCallable)new ViolationsCollector(false, targetPath, htmlPath, this.config));
        report.setConfig(this.config);
        report.setBuild(build);
        report.setBuildResult();
        build.getActions().add(new ViolationsBuildAction(build, report));
        return true;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new ViolationsProjectAction(project);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }
}

