/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.violations.parse;

import hudson.plugins.violations.model.FullBuildModel;
import hudson.plugins.violations.parse.AbstractTypeParser;
import hudson.plugins.violations.util.CloseUtil;
import hudson.util.IOException2;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserFactory;

public class ParseTypeXML {
    private static final Logger LOG = Logger.getLogger(ParseTypeXML.class.getName());

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parse(FullBuildModel model, File projectPath, String xmlFile, String[] sourcePaths, AbstractTypeParser typeParser) throws IOException {
        boolean bl;
        LOG.info("Parsing " + xmlFile);
        FileInputStream in = null;
        boolean success = false;
        try {
            in = projectPath == null ? new FileInputStream(new File(xmlFile)) : new FileInputStream(new File(projectPath, xmlFile));
            XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
            factory.setNamespaceAware(true);
            XmlPullParser parser = factory.newPullParser();
            parser.setInput((InputStream)in, null);
            typeParser.setProjectPath(projectPath);
            typeParser.setModel(model);
            typeParser.setParser(parser);
            typeParser.setSourcePaths(sourcePaths);
            typeParser.execute();
            success = true;
            bl = !success;
        }
        catch (IOException ex) {
            try {
                throw ex;
                catch (Exception ex2) {
                    throw new IOException2((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                CloseUtil.close(in, (!success ? 1 : 0) != 0);
                throw throwable;
            }
        }
        CloseUtil.close((Closeable)in, (boolean)bl);
    }
}

