/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.violations.types.cpplint;

import hudson.plugins.violations.ViolationsParser;
import hudson.plugins.violations.model.FullBuildModel;
import hudson.plugins.violations.model.FullFileModel;
import hudson.plugins.violations.model.Violation;
import hudson.plugins.violations.types.cpplint.CppLintParser;
import hudson.plugins.violations.util.AbsoluteFileFinder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CppLintParser
implements ViolationsParser {
    private final transient Pattern pattern;
    private transient AbsoluteFileFinder absoluteFileFinder = new AbsoluteFileFinder();

    public CppLintParser() {
        this.pattern = Pattern.compile("(.*):(\\d+): (.*) \\[(.*)\\] \\[(.*)\\]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(FullBuildModel model, File projectPath, String fileName, String[] sourcePaths) throws IOException {
        BufferedReader reader = null;
        this.absoluteFileFinder.addSourcePath(projectPath.getAbsolutePath());
        this.absoluteFileFinder.addSourcePaths(sourcePaths);
        try {
            reader = new BufferedReader(new FileReader(new File(projectPath, fileName)));
            String line = reader.readLine();
            while (line != null) {
                this.parseLine(model, line, projectPath);
                line = reader.readLine();
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public void parseLine(FullBuildModel model, String line, File projectPath) {
        CppLintViolation cppLintViolation = this.getCppLintViolation(line);
        if (cppLintViolation != null) {
            Violation violation = new Violation();
            violation.setType("cpplint");
            violation.setLine(cppLintViolation.getLineStr());
            violation.setMessage(cppLintViolation.getMessage());
            violation.setSource(cppLintViolation.getViolationId());
            this.setServerityLevel(violation, cppLintViolation.getViolationId());
            FullFileModel fileModel = this.getFileModel(model, cppLintViolation.getFileName(), this.absoluteFileFinder.getFileForName(cppLintViolation.getFileName()));
            fileModel.addViolation(violation);
        }
    }

    private FullFileModel getFileModel(FullBuildModel model, String name, File sourceFile) {
        FullFileModel fileModel = model.getFileModel(name);
        File other = fileModel.getSourceFile();
        if (sourceFile == null || other != null && (other.equals(sourceFile) || other.exists())) {
            return fileModel;
        }
        fileModel.setSourceFile(sourceFile);
        fileModel.setLastModified(sourceFile.lastModified());
        return fileModel;
    }

    CppLintViolation getCppLintViolation(String line) {
        Matcher matcher = this.pattern.matcher(line);
        if (matcher.find() && matcher.groupCount() == 5) {
            return new CppLintViolation(this, matcher);
        }
        return null;
    }

    private void setServerityLevel(Violation violation, String confidenceType) {
        switch (confidenceType.charAt(0)) {
            case '1': 
            case '2': {
                violation.setSeverity("Low");
                violation.setSeverityLevel(4);
                break;
            }
            default: {
                violation.setSeverity("Medium Low");
                violation.setSeverityLevel(3);
                break;
            }
            case '5': {
                violation.setSeverity("High");
                violation.setSeverityLevel(0);
            }
        }
    }
}

