/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.violations.types.pep8;

import hudson.plugins.violations.ViolationsParser;
import hudson.plugins.violations.model.FullBuildModel;
import hudson.plugins.violations.model.FullFileModel;
import hudson.plugins.violations.model.Violation;
import hudson.plugins.violations.types.pep8.Pep8Parser;
import hudson.plugins.violations.util.AbsoluteFileFinder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Pep8Parser
implements ViolationsParser {
    private final transient Pattern pattern;
    public static int MATCH_MIN_GROUP_COUNT = 4;
    private transient AbsoluteFileFinder absoluteFileFinder = new AbsoluteFileFinder();

    public Pep8Parser() {
        this.pattern = Pattern.compile("(.*):(\\d+):\\d+: (\\D\\d*) (.*)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(FullBuildModel model, File projectPath, String fileName, String[] sourcePaths) throws IOException {
        BufferedReader reader = null;
        this.absoluteFileFinder.addSourcePath(projectPath.getAbsolutePath());
        this.absoluteFileFinder.addSourcePaths(sourcePaths);
        try {
            reader = new BufferedReader(new FileReader(new File(projectPath, fileName)));
            String line = reader.readLine();
            while (line != null) {
                this.parseLine(model, line, projectPath);
                line = reader.readLine();
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public void parseLine(FullBuildModel model, String line, File projectPath) {
        Pep8Violation pep8Violation = this.getPep8Violation(line);
        if (pep8Violation != null) {
            Violation violation = new Violation();
            violation.setType("pep8");
            violation.setLine(pep8Violation.getLineStr());
            violation.setMessage(pep8Violation.getMessage());
            violation.setSource(pep8Violation.getViolationId());
            this.setServerityLevel(violation, pep8Violation.getViolationId());
            FullFileModel fileModel = this.getFileModel(model, pep8Violation.getFileName(), this.absoluteFileFinder.getFileForName(pep8Violation.getFileName()));
            fileModel.addViolation(violation);
        }
    }

    private FullFileModel getFileModel(FullBuildModel model, String name, File sourceFile) {
        FullFileModel fileModel = model.getFileModel(name);
        File other = fileModel.getSourceFile();
        if (sourceFile == null || other != null && (other.equals(sourceFile) || other.exists())) {
            return fileModel;
        }
        fileModel.setSourceFile(sourceFile);
        fileModel.setLastModified(sourceFile.lastModified());
        return fileModel;
    }

    Pep8Violation getPep8Violation(String line) {
        Matcher matcher = this.pattern.matcher(line);
        if (matcher.find() && matcher.groupCount() == MATCH_MIN_GROUP_COUNT) {
            return new Pep8Violation(this, matcher);
        }
        return null;
    }

    private void setServerityLevel(Violation violation, String messageType) {
        switch (messageType.charAt(0)) {
            case 'E': {
                violation.setSeverity("Medium");
                violation.setSeverityLevel(2);
                break;
            }
            default: {
                violation.setSeverity("Low");
                violation.setSeverityLevel(4);
            }
        }
    }
}

