/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.violations;

import hudson.plugins.violations.ViolationsParser;
import hudson.plugins.violations.types.checkstyle.CheckstyleDescriptor;
import hudson.plugins.violations.types.codenarc.CodenarcDescriptor;
import hudson.plugins.violations.types.cpd.CPDDescriptor;
import hudson.plugins.violations.types.cpplint.CppLintDescriptor;
import hudson.plugins.violations.types.csslint.CssLintDescriptor;
import hudson.plugins.violations.types.findbugs.FindBugsDescriptor;
import hudson.plugins.violations.types.fxcop.FxCopDescriptor;
import hudson.plugins.violations.types.gendarme.GendarmeDescriptor;
import hudson.plugins.violations.types.jcreport.JcReportDescriptor;
import hudson.plugins.violations.types.jslint.JsLintDescriptor;
import hudson.plugins.violations.types.pep8.Pep8Descriptor;
import hudson.plugins.violations.types.pmd.PMDDescriptor;
import hudson.plugins.violations.types.pylint.PyLintDescriptor;
import hudson.plugins.violations.types.simian.SimianDescriptor;
import hudson.plugins.violations.types.stylecop.StyleCopDescriptor;
import java.util.List;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TypeDescriptor {
    private final String name;
    public static final TreeMap<String, TypeDescriptor> TYPES = new TreeMap();

    protected TypeDescriptor(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public abstract ViolationsParser createParser();

    public static void addDescriptor(TypeDescriptor t) {
        TYPES.put(t.getName(), t);
    }

    public String getDetailForSource(String source) {
        return null;
    }

    public List<String> getMavenTargets() {
        return null;
    }

    static {
        TypeDescriptor.addDescriptor(FindBugsDescriptor.DESCRIPTOR);
        TypeDescriptor.addDescriptor(PMDDescriptor.DESCRIPTOR);
        TypeDescriptor.addDescriptor(CPDDescriptor.DESCRIPTOR);
        TypeDescriptor.addDescriptor(CheckstyleDescriptor.DESCRIPTOR);
        TypeDescriptor.addDescriptor(PyLintDescriptor.DESCRIPTOR);
        TypeDescriptor.addDescriptor(CppLintDescriptor.DESCRIPTOR);
        TypeDescriptor.addDescriptor(FxCopDescriptor.DESCRIPTOR);
        TypeDescriptor.addDescriptor(SimianDescriptor.DESCRIPTOR);
        TypeDescriptor.addDescriptor(StyleCopDescriptor.DESCRIPTOR);
        TypeDescriptor.addDescriptor(GendarmeDescriptor.DESCRIPTOR);
        TypeDescriptor.addDescriptor(JcReportDescriptor.DESCRIPTOR);
        TypeDescriptor.addDescriptor(JsLintDescriptor.DESCRIPTOR);
        TypeDescriptor.addDescriptor(CssLintDescriptor.DESCRIPTOR);
        TypeDescriptor.addDescriptor(CodenarcDescriptor.DESCRIPTOR);
        TypeDescriptor.addDescriptor(Pep8Descriptor.DESCRIPTOR);
    }
}

