/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.violations.model;

import hudson.Util;
import hudson.plugins.violations.TypeDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Violation
implements Comparable<Violation> {
    private int line;
    private String message;
    private String popupMessage;
    private String source;
    private int severityLevel;
    private String severity;
    private String type;

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public void setLine(String line) {
        try {
            this.line = Integer.parseInt(line);
        }
        catch (Exception ex) {
            this.line = 0;
        }
    }

    public int getLine() {
        return this.line;
    }

    public void setSeverityLevel(int severityLevel) {
        this.severityLevel = severityLevel;
    }

    public int getSeverityLevel() {
        return this.severityLevel;
    }

    public void setSeverity(String severity) {
        this.severity = severity;
    }

    public String getSeverity() {
        return this.severity;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public void setPopupMessage(String popupMessage) {
        this.popupMessage = popupMessage;
    }

    public String getPopupMessage() {
        if (this.popupMessage == null) {
            return this.message;
        }
        return this.popupMessage;
    }

    public String getSourceDetail() {
        String ret = TypeDescriptor.TYPES.get(this.type).getDetailForSource(this.source);
        if (ret == null) {
            ret = this.getPopupMessage();
        }
        return ret;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSource() {
        int pos = this.source.lastIndexOf(46);
        if (pos != -1) {
            return this.source.substring(pos + 1);
        }
        return this.source;
    }

    @Override
    public int compareTo(Violation other) {
        if (this == other) {
            return 0;
        }
        if (this.line < other.line) {
            return -1;
        }
        if (this.line > other.line) {
            return 1;
        }
        int f = this.type.compareTo(other.type);
        if (f != 0) {
            return f;
        }
        f = this.severity.compareTo(other.severity);
        if (f != 0) {
            return f;
        }
        f = Util.fixNull((String)this.message).compareTo(Util.fixNull((String)other.message));
        if (f != 0) {
            return f;
        }
        if (this.hashCode() < other.hashCode()) {
            return -1;
        }
        return 1;
    }
}

