/*
 * Decompiled with CFR 0.152.
 */
package hudson.os.windows;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.TaskListener;
import hudson.remoting.Channel;
import hudson.util.IOException2;
import hudson.util.StreamCopyThread;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Map;
import org.jinterop.dcom.common.JIException;
import org.jvnet.hudson.remcom.WindowsRemoteProcessLauncher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WindowsRemoteLauncher
extends Launcher {
    private final WindowsRemoteProcessLauncher launcher;

    public WindowsRemoteLauncher(TaskListener listener, WindowsRemoteProcessLauncher launcher) {
        super(listener, null);
        this.launcher = launcher;
    }

    private String buildCommandLine(Launcher.ProcStarter ps) {
        StringBuilder b = new StringBuilder();
        for (String cmd : ps.cmds()) {
            if (b.length() > 0) {
                b.append(' ');
            }
            if (cmd.indexOf(32) >= 0) {
                b.append('\"').append(cmd).append('\"');
                continue;
            }
            b.append(cmd);
        }
        return b.toString();
    }

    public Proc launch(Launcher.ProcStarter ps) throws IOException {
        Process proc;
        this.maskedPrintCommandLine(ps.cmds(), ps.masks(), ps.pwd());
        String name = ps.cmds().toString();
        try {
            proc = this.launcher.launch(this.buildCommandLine(ps), ps.pwd().getRemote());
        }
        catch (JIException e) {
            throw new IOException2((Throwable)e);
        }
        catch (InterruptedException e) {
            throw new IOException2((Throwable)e);
        }
        StreamCopyThread t1 = new StreamCopyThread("stdout copier: " + name, proc.getInputStream(), ps.stdout(), false);
        t1.start();
        StreamCopyThread t2 = new StreamCopyThread("stdin copier: " + name, ps.stdin(), proc.getOutputStream(), true);
        t2.start();
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public Channel launchChannel(String[] cmd, OutputStream out, FilePath _workDir, Map<String, String> envVars) throws IOException, InterruptedException {
        this.printCommandLine(cmd, _workDir);
        try {
            Process proc = this.launcher.launch(Util.join(Arrays.asList(cmd), (String)" "), _workDir.getRemote());
            return new Channel("channel over named pipe to " + this.launcher.getHostName(), Computer.threadPoolForRemoting, proc.getInputStream(), (OutputStream)new BufferedOutputStream(proc.getOutputStream()));
        }
        catch (JIException e) {
            throw new IOException2((Throwable)e);
        }
    }

    public void kill(Map<String, String> modelEnvVars) throws IOException, InterruptedException {
    }
}

