/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ws_cleanup;

import hudson.AbortException;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.plugins.ws_cleanup.Cleanup;
import hudson.plugins.ws_cleanup.Pattern;
import hudson.plugins.ws_cleanup.PreBuildCleanup;
import hudson.tasks.BuildWrapper;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreBuildCleanup
extends BuildWrapper {
    private final List<Pattern> patterns;
    private final boolean deleteDirs;

    @DataBoundConstructor
    public PreBuildCleanup(List<Pattern> patterns, boolean deleteDirs) {
        this.patterns = patterns;
        this.deleteDirs = deleteDirs;
    }

    public List<Pattern> getPatterns() {
        return this.patterns;
    }

    public boolean getDeleteDirs() {
        return this.deleteDirs;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        NoopEnv env = new NoopEnv(this);
        listener.getLogger().append("\nDeleting project workspace... \n");
        FilePath ws = build.getWorkspace();
        if (ws != null) {
            try {
                int retry = 3;
                while (true) {
                    try {
                        if (ws == null || !ws.exists()) {
                            return env;
                        }
                        if (this.patterns == null || this.patterns.isEmpty()) {
                            ws.deleteRecursive();
                        } else {
                            build.getWorkspace().act((FilePath.FileCallable)new Cleanup(this.patterns, this.deleteDirs));
                        }
                        listener.getLogger().append("done\n\n");
                    }
                    catch (IOException e) {
                        if (--retry > 0) {
                            Thread.sleep(3000L);
                            continue;
                        }
                        listener.getLogger().append("Cannot delete workspace: " + e.getCause() + "\n");
                        Logger.getLogger(PreBuildCleanup.class.getName()).log(Level.SEVERE, null, e);
                        e.printStackTrace();
                        throw new AbortException("Cannot delete workspace: " + e.getCause());
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                Logger.getLogger(PreBuildCleanup.class.getName()).log(Level.SEVERE, null, e);
                e.printStackTrace();
            }
        }
        return env;
    }
}

