/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ws_cleanup;

import hudson.FilePath;
import hudson.Launcher;
import hudson.matrix.MatrixAggregatable;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.plugins.ws_cleanup.Cleanup;
import hudson.plugins.ws_cleanup.Pattern;
import hudson.plugins.ws_cleanup.WsCleanupMatrixAggregator;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsCleanup
extends Notifier
implements MatrixAggregatable {
    private final List<Pattern> patterns;
    private final boolean deleteDirs;
    private final boolean skipWhenFailed;
    private final boolean notFailBuild;
    private final boolean cleanupMatrixParent;

    @DataBoundConstructor
    public WsCleanup(List<Pattern> patterns, boolean deleteDirs, boolean skipWhenFailed, boolean notFailBuild, boolean cleanupMatrixParent) {
        this.patterns = patterns;
        this.deleteDirs = deleteDirs;
        this.skipWhenFailed = skipWhenFailed;
        this.notFailBuild = notFailBuild;
        this.cleanupMatrixParent = cleanupMatrixParent;
    }

    public List<Pattern> getPatterns() {
        return this.patterns;
    }

    public boolean getDeleteDirs() {
        return this.deleteDirs;
    }

    public boolean getSkipWhenFailed() {
        return this.skipWhenFailed;
    }

    public boolean getNotFailBuild() {
        return this.notFailBuild;
    }

    public boolean getCleanupMatrixParent() {
        return this.cleanupMatrixParent;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        listener.getLogger().append("\nDeleting project workspace... \n");
        FilePath workspace = build.getWorkspace();
        try {
            if (workspace == null || !workspace.exists()) {
                return true;
            }
            if (this.skipWhenFailed && build.getResult().isWorseOrEqualTo(Result.FAILURE)) {
                listener.getLogger().append("skipped for failed build\n\n");
                return true;
            }
            if (this.patterns == null || this.patterns.isEmpty()) {
                workspace.deleteRecursive();
            } else {
                workspace.act((FilePath.FileCallable)new Cleanup(this.patterns, this.deleteDirs));
            }
            listener.getLogger().append("done\n\n");
        }
        catch (Exception ex) {
            Logger.getLogger(WsCleanup.class.getName()).log(Level.SEVERE, null, ex);
            if (this.notFailBuild) {
                listener.getLogger().append("Cannot delete workspace: " + ex.getCause() + "\n");
                listener.getLogger().append("Option not to fail the build is turned on, so let's continue\n");
                return true;
            }
            return false;
        }
        return true;
    }

    public MatrixAggregator createAggregator(MatrixBuild build, Launcher launcher, BuildListener listener) {
        if (this.cleanupMatrixParent) {
            return new WsCleanupMatrixAggregator(build, launcher, listener, this.patterns, this.deleteDirs, this.skipWhenFailed, this.notFailBuild);
        }
        return null;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.STEP;
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }
}

