/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ws_cleanup;

import hudson.FilePath;
import hudson.Launcher;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.plugins.ws_cleanup.Cleanup;
import hudson.plugins.ws_cleanup.Pattern;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsCleanupMatrixAggregator
extends MatrixAggregator {
    private final List<Pattern> patterns;
    private final boolean deleteDirs;
    private final boolean skipWhenFailed;
    private final boolean notFailBuild;

    public WsCleanupMatrixAggregator(MatrixBuild build, Launcher launcher, BuildListener listener, List<Pattern> patterns, boolean deleteDirs, boolean skipWhenFailed, boolean notFailBuid) {
        super(build, launcher, listener);
        this.patterns = patterns;
        this.deleteDirs = deleteDirs;
        this.skipWhenFailed = skipWhenFailed;
        this.notFailBuild = notFailBuid;
    }

    public boolean endBuild() throws InterruptedException, IOException {
        return this.doWorkspaceCleanup();
    }

    private boolean doWorkspaceCleanup() throws IOException, InterruptedException {
        this.listener.getLogger().append("\nDeleting matrix project workspace... \n");
        FilePath workspace = this.build.getWorkspace();
        try {
            if (workspace == null || !workspace.exists()) {
                return true;
            }
            if (this.skipWhenFailed && this.build.getResult().isWorseOrEqualTo(Result.FAILURE)) {
                this.listener.getLogger().append("skipped for failed build\n\n");
                return true;
            }
            if (this.patterns == null || this.patterns.isEmpty()) {
                workspace.deleteRecursive();
            } else {
                workspace.act((FilePath.FileCallable)new Cleanup(this.patterns, this.deleteDirs));
            }
            this.listener.getLogger().append("done\n\n");
        }
        catch (Exception ex) {
            Logger.getLogger(WsCleanupMatrixAggregator.class.getName()).log(Level.SEVERE, null, ex);
            if (this.notFailBuild) {
                this.listener.getLogger().append("Cannot delete workspace: " + ex.getCause() + "\n");
                this.listener.getLogger().append("Option not to fail the build is turned on, so let's continue\n");
                return true;
            }
            return false;
        }
        return true;
    }
}

