/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ws_cleanup;

import hudson.FilePath;
import hudson.Util;
import hudson.plugins.ws_cleanup.Pattern;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.DirectoryScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Cleanup
implements FilePath.FileCallable<Object> {
    private final List<Pattern> patterns;
    private final boolean deleteDirs;

    public Cleanup(List<Pattern> patterns, boolean deleteDirs) {
        this.patterns = patterns;
        this.deleteDirs = deleteDirs;
    }

    public boolean getDeleteDirs() {
        return this.deleteDirs;
    }

    public Object invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(f);
        ArrayList<String> includes = new ArrayList<String>();
        ArrayList<String> excludes = new ArrayList<String>();
        for (Pattern pattern : this.patterns) {
            if (pattern.getType() == Pattern.PatternType.INCLUDE) {
                includes.add(pattern.getPattern());
                continue;
            }
            excludes.add(pattern.getPattern());
        }
        if (includes.size() == 0) {
            includes.add("**/*");
        }
        String[] includesArray = new String[includes.size()];
        String[] excludesArray = new String[excludes.size()];
        includes.toArray(includesArray);
        excludes.toArray(excludesArray);
        ds.setIncludes(includesArray);
        ds.setExcludes(excludesArray);
        ds.scan();
        int length = ds.getIncludedFilesCount();
        if (this.deleteDirs) {
            length += ds.getIncludedDirsCount();
        }
        String[] toDelete = new String[length];
        System.arraycopy(ds.getIncludedFiles(), 0, toDelete, 0, ds.getIncludedFilesCount());
        if (this.deleteDirs) {
            System.arraycopy(ds.getIncludedDirectories(), 0, toDelete, ds.getIncludedFilesCount(), ds.getIncludedDirsCount());
        }
        for (String path : toDelete) {
            Util.deleteRecursive((File)new File(f, path));
        }
        return null;
    }
}

