/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ws_cleanup;

import hudson.Extension;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.util.ListBoxModel;
import java.io.Serializable;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pattern
implements Serializable,
Describable<Pattern> {
    private final String pattern;
    private PatternType type;
    private static final long serialVerisonUID = 1L;

    @DataBoundConstructor
    public Pattern(String pattern, PatternType type) {
        this.pattern = pattern;
        this.type = type;
    }

    public Object readResolve() {
        if (this.type == null) {
            this.type = PatternType.INCLUDE;
        }
        return this;
    }

    public String getPattern() {
        return this.pattern;
    }

    public PatternType getType() {
        return this.type;
    }

    public Descriptor<Pattern> getDescriptor() {
        return Hudson.getInstance().getDescriptor(this.getClass());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PatternType {
        INCLUDE,
        EXCLUDE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends Descriptor<Pattern> {
        public String getDisplayName() {
            return "Directory scanner pattern";
        }

        public ListBoxModel doFillTypeItems() {
            ListBoxModel model = new ListBoxModel(2);
            model.add("Include", PatternType.INCLUDE.toString());
            model.add("Exclude", PatternType.EXCLUDE.toString());
            return model;
        }
    }
}

