/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.xvnc;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;

final class DisplayAllocator {
    private final Set<Integer> allocatedNumbers = new HashSet();
    private final Set<Integer> blacklistedNumbers = new HashSet();
    private final int minDisplayNumber;
    private final int maxDisplayNumber;

    public DisplayAllocator(int minDisplayNumber, int maxDisplayNumber) {
        this.minDisplayNumber = minDisplayNumber;
        this.maxDisplayNumber = maxDisplayNumber;
    }

    private final int getRandomValue() {
        return this.minDisplayNumber + new Random().nextInt(this.getRange());
    }

    private int getRange() {
        return this.maxDisplayNumber + 1 - this.minDisplayNumber;
    }

    public synchronized int allocate() {
        int displayNumber;
        if (this.noDisplayNumbersLeft()) {
            if (!this.blacklistedNumbers.isEmpty()) {
                this.blacklistedNumbers.clear();
            } else {
                throw new RuntimeException("All available display numbers are allocated or blacklisted.\nallocated: " + this.allocatedNumbers.toString() + "\nblacklisted: " + this.blacklistedNumbers.toString());
            }
        }
        while (this.isNotAvailable(displayNumber = this.getRandomValue())) {
        }
        this.allocatedNumbers.add(displayNumber);
        return displayNumber;
    }

    private boolean isNotAvailable(int number) {
        return this.allocatedNumbers.contains(number) || this.blacklistedNumbers.contains(number);
    }

    private boolean noDisplayNumbersLeft() {
        return this.allocatedNumbers.size() + this.blacklistedNumbers.size() >= this.getRange();
    }

    public synchronized void free(int n) {
        this.allocatedNumbers.remove(n);
    }

    public void blacklist(int badDisplay) {
        this.free(badDisplay);
        this.blacklistedNumbers.add(badDisplay);
    }
}

