/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.xvnc;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.plugins.xvnc.DisplayAllocator;
import hudson.plugins.xvnc.Messages;
import hudson.plugins.xvnc.NodePropertyImpl;
import hudson.plugins.xvnc.Xvnc;
import hudson.tasks.BuildWrapper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * Exception performing whole class analysis ignored.
 */
public class Xvnc
extends BuildWrapper {
    public boolean takeScreenshot;
    private DisplayAllocator allocator;
    private static final String FILENAME_SCREENSHOT = "screenshot.jpg";
    private static final Map<Node, Boolean> cleanedUpOn = new WeakHashMap();

    @DataBoundConstructor
    public Xvnc(boolean takeScreenshot) {
        this.takeScreenshot = takeScreenshot;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        PrintStream logger = listener.getLogger();
        DescriptorImpl DESCRIPTOR = (DescriptorImpl)Hudson.getInstance().getDescriptorByType(DescriptorImpl.class);
        if (build.getBuiltOn().getAssignedLabels().contains(Hudson.getInstance().getLabelAtom("noxvnc")) || build.getBuiltOn().getNodeProperties().get(NodePropertyImpl.class) != null) {
            return new /* Unavailable Anonymous Inner Class!! */;
        }
        if (DESCRIPTOR.skipOnWindows && !launcher.isUnix()) {
            return new /* Unavailable Anonymous Inner Class!! */;
        }
        if (DESCRIPTOR.cleanUp) {
            Xvnc.maybeCleanUp((Launcher)launcher, (BuildListener)listener);
        }
        String cmd = Util.nullify((String)DESCRIPTOR.xvnc);
        this.allocator = new DisplayAllocator(DESCRIPTOR.minDisplayNumber, DESCRIPTOR.maxDisplayNumber);
        if (cmd == null) {
            cmd = "vncserver :$DISPLAY_NUMBER -localhost -nolisten tcp";
        }
        return this.doSetUp(build, launcher, logger, cmd, 10);
    }

    private BuildWrapper.Environment doSetUp(AbstractBuild build, Launcher launcher, PrintStream logger, String cmd, int retries) throws IOException, InterruptedException {
        String vncserverCommand;
        int displayNumber = this.allocator.allocate();
        String actualCmd = Util.replaceMacro((String)cmd, Collections.singletonMap("DISPLAY_NUMBER", String.valueOf(displayNumber)));
        logger.println(Messages.Xvnc_STARTING());
        String[] cmds = Util.tokenize((String)actualCmd);
        FilePath xauthority = build.getWorkspace().createTempFile(".Xauthority-", "");
        Map<String, String> xauthorityEnv = Collections.singletonMap("XAUTHORITY", xauthority.getRemote());
        Proc proc = launcher.launch().cmds(cmds).envs(xauthorityEnv).stdout((OutputStream)logger).pwd(build.getWorkspace()).start();
        if (cmds[0].endsWith("vncserver") && cmd.contains(":$DISPLAY_NUMBER")) {
            vncserverCommand = cmds[0];
            int exit = proc.join();
            if (exit != 0) {
                String message = "Failed to run '" + actualCmd + "' (exit code " + exit + "), blacklisting display #" + displayNumber + "; consider checking the \"Clean up before start\" option";
                this.allocator.blacklist(displayNumber);
                if (retries > 0) {
                    return this.doSetUp(build, launcher, logger, cmd, retries - 1);
                }
                throw new IOException(message);
            }
        } else {
            vncserverCommand = null;
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private static synchronized void maybeCleanUp(Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        Node node = Computer.currentComputer().getNode();
        if (cleanedUpOn.put(node, true) != null) {
            return;
        }
        if (!launcher.isUnix()) {
            listener.error("Clean up not currently implemented for non-Unix nodes; skipping");
            return;
        }
        PrintStream logger = listener.getLogger();
        launcher.launch().stdout((OutputStream)logger).cmds(new String[]{"pkill", "Xvnc"}).join();
        launcher.launch().stdout((OutputStream)logger).cmds(new String[]{"pkill", "Xrealvnc"}).join();
        launcher.launch().stdout((OutputStream)logger).cmds(new String[]{"sh", "-c", "rm -f /tmp/.X*-lock /tmp/.X11-unix/X*"}).join();
    }

    static /* synthetic */ DisplayAllocator access$000(Xvnc x0) {
        return x0.allocator;
    }
}

