/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.xvnc;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;

final class DisplayAllocator {
    private final Set<Integer> allocatedNumbers = new HashSet();
    private final Set<Integer> blacklistedNumbers = new HashSet();

    private final int getRandomValue(int min, int max) {
        return min + new Random().nextInt(this.getRange(min, max));
    }

    private int getRange(int min, int max) {
        return max + 1 - min;
    }

    public synchronized int allocate(int minDisplayNumber, int maxDisplayNumber) {
        int displayNumber;
        if (this.noDisplayNumbersLeft(minDisplayNumber, maxDisplayNumber)) {
            if (!this.blacklistedNumbers.isEmpty()) {
                this.blacklistedNumbers.clear();
            } else {
                throw new RuntimeException("All available display numbers are allocated or blacklisted.\nallocated: " + this.allocatedNumbers.toString() + "\nblacklisted: " + this.blacklistedNumbers.toString());
            }
        }
        while (this.isNotAvailable(displayNumber = this.getRandomValue(minDisplayNumber, maxDisplayNumber))) {
        }
        this.allocatedNumbers.add(displayNumber);
        return displayNumber;
    }

    private boolean isNotAvailable(int number) {
        return this.allocatedNumbers.contains(number) || this.blacklistedNumbers.contains(number);
    }

    private boolean noDisplayNumbersLeft(int min, int max) {
        return this.allocatedNumbers.size() + this.blacklistedNumbers.size() >= this.getRange(min, max);
    }

    public synchronized void free(int n) {
        this.allocatedNumbers.remove(n);
    }

    public void blacklist(int badDisplay) {
        this.free(badDisplay);
        this.blacklistedNumbers.add(badDisplay);
    }
}

