/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.xvnc;

import hudson.model.Saveable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

final class DisplayAllocator {
    transient Saveable owner;
    private final Set<Integer> allocatedNumbers = new HashSet<Integer>();
    private final Set<Integer> blacklistedNumbers = new HashSet<Integer>();

    private void save() {
        if (this.owner != null) {
            try {
                this.owner.save();
            }
            catch (IOException x) {
                Logger.getLogger(DisplayAllocator.class.getName()).log(Level.WARNING, null, x);
            }
        }
    }

    private int getRandomValue(int min, int max) {
        return min + new Random().nextInt(this.getRange(min, max));
    }

    private int getRange(int min, int max) {
        return max + 1 - min;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int allocate(int minDisplayNumber, int maxDisplayNumber) {
        try {
            int n = this.doAllocate(minDisplayNumber, maxDisplayNumber);
            return n;
        }
        finally {
            this.save();
        }
    }

    private synchronized int doAllocate(int minDisplayNumber, int maxDisplayNumber) {
        int displayNumber;
        if (this.noDisplayNumbersLeft(minDisplayNumber, maxDisplayNumber)) {
            if (!this.blacklistedNumbers.isEmpty()) {
                this.blacklistedNumbers.clear();
            } else {
                throw new RuntimeException("All available display numbers are allocated or blacklisted.\nallocated: " + this.allocatedNumbers.toString() + "\nblacklisted: " + this.blacklistedNumbers.toString());
            }
        }
        while (this.isNotAvailable(displayNumber = this.getRandomValue(minDisplayNumber, maxDisplayNumber))) {
        }
        this.allocatedNumbers.add(displayNumber);
        return displayNumber;
    }

    private boolean isNotAvailable(int number) {
        return this.allocatedNumbers.contains(number) || this.blacklistedNumbers.contains(number);
    }

    private boolean noDisplayNumbersLeft(int min, int max) {
        return this.allocatedNumbers.size() + this.blacklistedNumbers.size() >= this.getRange(min, max);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void free(int n) {
        DisplayAllocator displayAllocator = this;
        synchronized (displayAllocator) {
            this.allocatedNumbers.remove(n);
        }
        this.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blacklist(int badDisplay) {
        DisplayAllocator displayAllocator = this;
        synchronized (displayAllocator) {
            this.allocatedNumbers.remove(badDisplay);
            this.blacklistedNumbers.add(badDisplay);
        }
        this.save();
    }
}

