/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.tags.core;

import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.MissingAttributeException;
import org.apache.commons.jelly.TagSupport;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jelly.expression.Expression;
import org.apache.commons.jelly.impl.BreakException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WhileTag
extends TagSupport {
    private static final Log log = LogFactory.getLog(WhileTag.class);
    private Expression test;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doTag(XMLOutput output) throws MissingAttributeException, JellyTagException {
        if (this.test == null) throw new MissingAttributeException("test");
        try {
            while (this.test.evaluateAsBoolean(this.getContext())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"evaluated to true! gonna keep on chuggin!");
                }
                this.invokeBody(output);
            }
            return;
        }
        catch (BreakException e) {
            if (!log.isDebugEnabled()) return;
            log.debug((Object)("loop terminated by break: " + e), (Throwable)e);
            return;
        }
    }

    public void setTest(Expression e) {
        this.test = e;
    }
}

