/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.xpath;

import java.util.Comparator;
import java.util.List;
import org.apache.commons.jelly.util.NestedRuntimeException;
import org.dom4j.Node;
import org.hudsonci.xpath.XPath;
import org.hudsonci.xpath.XPathException;

public class XPathComparator
implements Comparator {
    private XPath xpath = null;
    private boolean descending = false;

    public XPathComparator() {
    }

    public XPathComparator(XPath xpath, boolean descending) {
        this.xpath = xpath;
        this.descending = descending;
    }

    public void setXpath(XPath xpath) {
        this.xpath = xpath;
    }

    public XPath getXpath() {
        return this.xpath;
    }

    public void setDescending(boolean descending) {
        this.descending = descending;
    }

    public int compare(Object o1, Object o2) {
        return this.compare((Node)o1, (Node)o2);
    }

    public int compare(Node n1, Node n2) {
        try {
            Object val1 = this.xpath.evaluate((Object)n1);
            Object val2 = this.xpath.evaluate((Object)n2);
            if (val1 == null || val2 == null) {
                return val1 == null ? (val2 == null ? 1 : -1) : 1;
            }
            Comparable c1 = this.getComparableValue(val1);
            Comparable c2 = this.getComparableValue(val2);
            if (!this.descending) {
                return c1.compareTo(c2);
            }
            return c2.compareTo(c1);
        }
        catch (XPathException e) {
            throw new XPathSortException("error sorting nodes", e);
        }
    }

    protected Comparable getComparableValue(Object value) {
        if (value instanceof List) {
            List list = (List)value;
            if (list.isEmpty()) {
                value = "";
            }
            if ((value = list.get(0)) == null) {
                value = "";
            }
        }
        if (value instanceof Comparable) {
            return (Comparable)value;
        }
        if (value instanceof Node) {
            Node node = (Node)value;
            return node.getStringValue();
        }
        return value.toString();
    }

    public static class XPathSortException
    extends NestedRuntimeException {
        public XPathSortException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

