/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.CompilationFailureException;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.compiler.util.scan.SimpleSourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.SourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.StaleSourceScanner;
import org.kohsuke.stapler.AbstractCompilerMojo;

public class TestCompilerMojo
extends AbstractCompilerMojo {
    private boolean skip;
    private List compileSourceRoots;
    private List classpathElements;
    private File outputDirectory;
    private Set testIncludes = new HashSet();
    private Set testExcludes = new HashSet();

    @Override
    public void execute() throws MojoExecutionException, CompilationFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Not compiling test sources");
        } else {
            super.execute();
        }
    }

    @Override
    protected List getCompileSourceRoots() {
        return this.compileSourceRoots;
    }

    @Override
    protected List getClasspathElements() {
        return this.classpathElements;
    }

    @Override
    protected File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    protected SourceInclusionScanner getSourceInclusionScanner(int staleMillis) {
        StaleSourceScanner scanner = null;
        if (this.testIncludes.isEmpty() && this.testExcludes.isEmpty()) {
            scanner = new StaleSourceScanner((long)staleMillis);
        } else {
            if (this.testIncludes.isEmpty()) {
                this.testIncludes.add("**/*.java");
            }
            scanner = new StaleSourceScanner((long)staleMillis, this.testIncludes, this.testExcludes);
        }
        return scanner;
    }

    @Override
    protected SourceInclusionScanner getSourceInclusionScanner(String inputFileEnding) {
        SimpleSourceInclusionScanner scanner = null;
        if (this.testIncludes.isEmpty() && this.testExcludes.isEmpty()) {
            this.testIncludes = Collections.singleton("**/*." + inputFileEnding);
            scanner = new SimpleSourceInclusionScanner(this.testIncludes, Collections.EMPTY_SET);
        } else {
            if (this.testIncludes.isEmpty()) {
                this.testIncludes.add("**/*." + inputFileEnding);
            }
            scanner = new SimpleSourceInclusionScanner(this.testIncludes, this.testExcludes);
        }
        return scanner;
    }
}

