/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.kohsuke.stapler.ClassDescriptor;

public class ClassDescriptorTest
extends TestCase {
    public ClassDescriptorTest() {
    }

    public ClassDescriptorTest(int a, int b, String x) {
    }

    public void testLoadConstructorParam() throws Exception {
        ClassDescriptorTest.assertEquals((int)0, (int)ClassDescriptor.loadParameterNames(((Object)((Object)this)).getClass().getConstructor(new Class[0])).length);
        String[] names = ClassDescriptor.loadParameterNames(((Object)((Object)this)).getClass().getConstructor(Integer.TYPE, Integer.TYPE, String.class));
        ClassDescriptorTest.assertEquals((String)"[a, b, x]", (String)Arrays.asList(names).toString());
    }

    public void testLoadParametersFromAsm() throws Exception {
        Method lpfa = ClassDescriptor.class.getDeclaredClasses()[0].getDeclaredMethod("loadParametersFromAsm", Method.class);
        lpfa.setAccessible(true);
        HashMap<String, Method> testCases = new HashMap<String, Method>();
        for (Method m : ClassDescriptorTest.class.getDeclaredMethods()) {
            if (!m.getName().startsWith("methodWith")) continue;
            testCases.put(m.getName().substring(10), m);
        }
        HashMap<String, String[]> expected = new HashMap<String, String[]>();
        expected.put("NoParams", new String[0]);
        expected.put("NoParams_static", new String[0]);
        expected.put("ManyParams", new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i"});
        expected.put("Params_static", new String[]{"abc", "def", "ghi"});
        for (Map.Entry entry : expected.entrySet()) {
            Method testMethod = (Method)testCases.get(entry.getKey());
            ClassDescriptorTest.assertNotNull((String)("Method missing for " + (String)entry.getKey()), (Object)testMethod);
            Object[] result = (String[])lpfa.invoke(null, testMethod);
            ClassDescriptorTest.assertNotNull((Object)("Null result for " + (String)entry.getKey()));
            if (Arrays.equals((Object[])entry.getValue(), result)) continue;
            StringBuilder buf = new StringBuilder(124);
            for (Object s : result) {
                buf.append((String)s).append('|');
            }
            ClassDescriptorTest.fail((String)("Unexpected result for " + (String)entry.getKey() + ": " + buf));
        }
    }

    private void methodWithNoParams() {
    }

    private static void methodWithNoParams_static() {
    }

    private void methodWithManyParams(String a, boolean b, int c, long d, Boolean e, Integer f, Long g, Object h, ClassDescriptorTest i) {
    }

    private static void methodWithParams_static(String abc, long def, Object ghi) {
    }
}

