/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import java.net.Proxy;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import junit.framework.TestCase;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.CapturedParameterNames;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.Function;
import org.kohsuke.stapler.MockRequest;
import org.kohsuke.stapler.ObjectWithCustomConverter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.RequestImpl;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public class DataBindingTest
extends TestCase {
    public void test1() {
        JSONObject json = new JSONObject();
        json.put("a", (Object)123);
        json.put("b", (Object)"string");
        Data data = this.bind(json, new Data());
        DataBindingTest.assertEquals((int)123, (int)data.a);
        DataBindingTest.assertEquals((String)"string", (String)data.myB);
    }

    public void testEnumSet() {
        JSONObject json = new JSONObject();
        json.put("DIRECT", (Object)false);
        json.put("HTTP", (Object)true);
        json.put("SOCKS", null);
        JSONObject container = new JSONObject();
        container.put("set", (Object)json);
        DataEnumSet data = this.bind(container, new DataEnumSet());
        DataBindingTest.assertTrue((boolean)data.set.contains((Object)Proxy.Type.HTTP));
        DataBindingTest.assertFalse((boolean)data.set.contains((Object)Proxy.Type.DIRECT));
        DataBindingTest.assertFalse((boolean)data.set.contains((Object)Proxy.Type.SOCKS));
    }

    public void testFromStaplerMethod() throws Exception {
        MockRequest mr = new MockRequest();
        mr.getParameterMap().put("a", "123");
        mr.getParameterMap().put("b", "string");
        RequestImpl req = new RequestImpl(new Stapler(), (HttpServletRequest)mr, Collections.emptyList(), null);
        new Function.InstanceFunction(((Object)((Object)this)).getClass().getMethod("doFromStaplerMethod", StaplerRequest.class, Integer.TYPE, Binder.class)).bindAndInvoke((Object)this, (StaplerRequest)req, null, new Object[0]);
    }

    public void doFromStaplerMethod(StaplerRequest req, @QueryParameter int a, Binder b) {
        DataBindingTest.assertEquals((int)123, (int)a);
        DataBindingTest.assertSame((Object)req, (Object)b.req);
        DataBindingTest.assertEquals((String)"string", (String)b.b);
    }

    public void testCustomConverter() throws Exception {
        ReferToObjectWithCustomConverter r = this.bind("{data:'1,2'}", ReferToObjectWithCustomConverter.class);
        DataBindingTest.assertEquals((int)r.data.x, (int)1);
        DataBindingTest.assertEquals((int)r.data.y, (int)2);
    }

    public void testNullToFalse() throws Exception {
        TwoBooleans r = this.bind("{a:false}", TwoBooleans.class);
        DataBindingTest.assertFalse((boolean)r.a);
        DataBindingTest.assertFalse((boolean)r.b);
    }

    public void testScalarToArray() throws Exception {
        ScalarToArray r = this.bind("{a:'x',b:'y',c:5,d:6}", ScalarToArray.class);
        DataBindingTest.assertEquals((String)"x", (String)r.a[0]);
        DataBindingTest.assertEquals((String)"y", (String)((String)r.b.get(0)));
        DataBindingTest.assertEquals((int)5, (int)r.c[0]);
        DataBindingTest.assertEquals((int)6, (int)((Integer)r.d.get(0)));
    }

    private <T> T bind(String json, Class<T> type) {
        RequestImpl req = new RequestImpl(new Stapler(), (HttpServletRequest)new MockRequest(), Collections.emptyList(), null);
        return (T)req.bindJSON(type, JSONObject.fromObject((Object)json));
    }

    private <T> T bind(JSONObject json, T bean) {
        RequestImpl req = new RequestImpl(new Stapler(), (HttpServletRequest)new MockRequest(), Collections.emptyList(), null);
        req.bindJSON(bean, json);
        return bean;
    }

    public void testRaw() {
        RawBinding r = this.bind("{x:{a:true,b:1},y:[1,2,3]}", RawBinding.class);
        RawBinding r2 = this.bind("{x:{a:true,b:1},y:{p:true}}", RawBinding.class);
        JSONObject o = (JSONObject)r2.y.get(0);
        DataBindingTest.assertTrue((boolean)o.getBoolean("p"));
        RawBinding r3 = this.bind("{x:{a:true,b:1},y:true}", RawBinding.class);
        DataBindingTest.assertTrue((boolean)((Boolean)r3.y.get(0)));
    }

    public static class RawBinding {
        JSONObject x;
        JSONArray y;

        @DataBoundConstructor
        public RawBinding(JSONObject x, JSONArray y) {
            this.x = x;
            this.y = y;
        }
    }

    public static class ScalarToArray {
        private String[] a;
        private List<String> b;
        private Integer[] c;
        private List<Integer> d;

        @DataBoundConstructor
        public ScalarToArray(String[] a, List<String> b, Integer[] c, List<Integer> d) {
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
        }
    }

    public static class TwoBooleans {
        private boolean a;
        private boolean b;

        @DataBoundConstructor
        public TwoBooleans(boolean a, boolean b) {
            this.a = a;
            this.b = b;
        }
    }

    public static class ReferToObjectWithCustomConverter {
        final ObjectWithCustomConverter data;

        @DataBoundConstructor
        public ReferToObjectWithCustomConverter(ObjectWithCustomConverter data) {
            this.data = data;
        }
    }

    public static class Binder {
        StaplerRequest req;
        String b;

        @CapturedParameterNames(value={"req", "b"})
        public static Binder fromStapler(StaplerRequest req, @QueryParameter String b) {
            Binder r = new Binder();
            r.req = req;
            r.b = b;
            return r;
        }
    }

    public class DataEnumSet {
        public EnumSet<Proxy.Type> set;
    }

    public class Data {
        public int a;
        String myB;

        public void setB(String s) {
            this.myB = s;
        }
    }
}

