/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import java.util.Collections;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import junit.framework.TestCase;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.MockRequest;
import org.kohsuke.stapler.RequestImpl;
import org.kohsuke.stapler.ServletConfigImpl;
import org.kohsuke.stapler.Stapler;

public class NestedJsonTest
extends TestCase {
    public void testCreateObject() throws Exception {
        Foo o = (Foo)this.createRequest().bindJSON(Foo.class, this.createDataSet());
        NestedJsonTest.assertNotNull((Object)o);
        NestedJsonTest.assertTrue((boolean)(o.bar instanceof BarImpl));
        NestedJsonTest.assertEquals((int)123, (int)((BarImpl)o.bar).i);
    }

    public void testInstanceFill() throws Exception {
        Foo o = new Foo(null);
        this.createRequest().bindJSON((Object)o, this.createDataSet());
        NestedJsonTest.assertTrue((boolean)(o.bar instanceof BarImpl));
        NestedJsonTest.assertEquals((int)123, (int)((BarImpl)o.bar).i);
    }

    public void testCreateList() throws Exception {
        List list = this.createRequest().bindJSONToList(Foo.class, (Object)this.createDataSet());
        NestedJsonTest.assertNotNull((Object)list);
        NestedJsonTest.assertEquals((int)1, (int)list.size());
        NestedJsonTest.assertTrue((boolean)(((Foo)list.get((int)0)).bar instanceof BarImpl));
        NestedJsonTest.assertEquals((int)123, (int)((BarImpl)((Foo)list.get((int)0)).bar).i);
        JSONArray data = new JSONArray();
        data.add((Object)this.createDataSet());
        data.add((Object)this.createDataSet());
        data.add((Object)this.createDataSet());
        list = this.createRequest().bindJSONToList(Foo.class, (Object)data);
        NestedJsonTest.assertNotNull((Object)list);
        NestedJsonTest.assertEquals((int)3, (int)list.size());
        NestedJsonTest.assertEquals((int)123, (int)((BarImpl)((Foo)list.get((int)2)).bar).i);
    }

    private RequestImpl createRequest() throws Exception {
        return new RequestImpl(this.createStapler(), (HttpServletRequest)new MockRequest(), Collections.EMPTY_LIST, null);
    }

    private JSONObject createDataSet() {
        JSONObject bar = new JSONObject();
        bar.put("i", (Object)123);
        JSONObject foo = new JSONObject();
        foo.put("bar", (Object)bar);
        foo.getJSONObject("bar").put("stapler-class", (Object)BarImpl.class.getName());
        return foo;
    }

    private Stapler createStapler() throws ServletException {
        Stapler stapler = new Stapler();
        stapler.init((ServletConfig)new ServletConfigImpl());
        return stapler;
    }

    public static final class BarImpl
    implements Bar {
        public final int i;

        @DataBoundConstructor
        public BarImpl(int i) {
            this.i = i;
        }
    }

    public static interface Bar {
    }

    public static final class Foo {
        public Bar bar;

        @DataBoundConstructor
        public Foo(Bar bar) {
            this.bar = bar;
        }
    }
}

