/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import junit.framework.TestCase;
import org.kohsuke.stapler.Stapler;

public class StaplerTest
extends TestCase {
    public void testNormalization() {
        this.assertIdemPotent("/");
        this.assertIdemPotent("");
        this.assertIdemPotent("/foo");
        this.assertIdemPotent("/bar/");
        this.assertIdemPotent("zot/");
        this.testC12n("", ".");
        this.testC12n("", "foo/..");
        this.testC12n("foo", "foo/bar/./..");
        this.testC12n("/abc", "/abc");
        this.testC12n("/abc/", "/abc/");
        this.testC12n("/", "/abc/../");
        this.testC12n("/", "/abc/def/../../");
        this.testC12n("/def", "/abc/../def");
        this.testC12n("/xxx", "/../../../xxx");
    }

    private void testC12n(String expected, String input) {
        StaplerTest.assertEquals((String)expected, (String)Stapler.canonicalPath((String)input));
    }

    private void assertIdemPotent(String str) {
        StaplerTest.assertEquals((String)str, (String)Stapler.canonicalPath((String)str));
    }
}

