/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.bind;

import com.gargoylesoftware.htmlunit.AlertHandler;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.WebApp;
import org.kohsuke.stapler.test.JettyTestCase;

public class JavaScriptProxyTest
extends JettyTestCase {
    private String anonymousValue;
    private Object anonymous = new MyObject();

    public void testBind() throws Exception {
        final String[] msg = new String[1];
        WebClient wc = new WebClient();
        wc.setAlertHandler(new AlertHandler(){

            public void handleAlert(Page page, String message) {
                msg[0] = message;
            }
        });
        HtmlPage page = (HtmlPage)wc.getPage(new URL(this.url, "/"));
        page.executeJavaScript("v.foo(3,'test',callback);");
        JavaScriptProxyTest.assertEquals((String)"string:test3", (String)msg[0]);
        page.executeJavaScript("v.foo(0,null,callback);");
        JavaScriptProxyTest.assertEquals((String)"object:null", (String)msg[0]);
    }

    public void testAnonymousBind() throws Exception {
        WebClient wc = new WebClient();
        HtmlPage page = (HtmlPage)wc.getPage(new URL(this.url, "/bindAnonymous"));
        page.executeJavaScript("v.xyz('hello');");
        JavaScriptProxyTest.assertEquals((String)"hello", (String)this.anonymousValue);
    }

    public String jsFoo(int x, String y) {
        if (x == 0) {
            return y;
        }
        return y + x;
    }

    public void doIndex(StaplerRequest req, StaplerResponse rsp) throws IOException {
        rsp.setContentType("text/html");
        String crumb = req.getWebApp().getCrumbIssuer().issueCrumb();
        PrintWriter w = rsp.getWriter();
        w.println("<html><body><script src='prototype'></script><script src='script'></script>");
        w.println("<script>var v = makeStaplerProxy('/','" + crumb + "',['foo','bar']);var callback = function(t){var x=t.responseObject();alert(typeof(x)+':'+x)};</script>");
        w.println("</body></html>");
    }

    public void doBindAnonymous(StaplerResponse rsp) throws IOException {
        rsp.setContentType("text/html");
        PrintWriter w = rsp.getWriter();
        w.println("<html><body><script src='prototype'></script><script src='script'></script>");
        w.println("<script>var v = " + WebApp.getCurrent().boundObjectTable.bind(this.anonymous).getProxyScript() + ";</script>");
        w.println("</body></html>");
    }

    public HttpResponse doPrototype() {
        return HttpResponses.staticResource((URL)((Object)((Object)this)).getClass().getResource("/org/kohsuke/stapler/framework/prototype/prototype.js"));
    }

    public HttpResponse doScript() {
        return HttpResponses.staticResource((URL)((Object)((Object)this)).getClass().getResource("/org/kohsuke/stapler/bind.js"));
    }

    public class MyObject {
        public void jsXyz(String s) {
            JavaScriptProxyTest.this.anonymousValue = s;
        }
    }
}

