/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.export;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.kohsuke.stapler.export.Flavor;
import org.kohsuke.stapler.export.Model;
import org.kohsuke.stapler.export.ModelBuilder;
import org.kohsuke.stapler.export.NamedPathPruner;
import org.kohsuke.stapler.export.TreePruner;

public class NamedPathPrunerTest
extends TestCase {
    public NamedPathPrunerTest(String name) {
        super(name);
    }

    public void testParse() throws Exception {
        NamedPathPrunerTest.assertEquals((String)"{a={}, b={c={}}}", (String)NamedPathPruner.parse((String)"a,b[c]").toString());
        NamedPathPrunerTest.assertEquals((String)"{a={}, b={c={}, d={}}}", (String)NamedPathPruner.parse((String)"a,b[c,d]").toString());
        NamedPathPrunerTest.assertEquals((String)"{a={}, b={c={}, d={}}, e={}}", (String)NamedPathPruner.parse((String)"a,b[c,d],e").toString());
        NamedPathPrunerTest.assertParseError("");
        NamedPathPrunerTest.assertParseError("a,");
        NamedPathPrunerTest.assertParseError(",b");
        NamedPathPrunerTest.assertParseError("a[");
        NamedPathPrunerTest.assertParseError("a[b,c");
        NamedPathPrunerTest.assertParseError("a[]");
        NamedPathPrunerTest.assertParseError("a[b,,]");
        NamedPathPrunerTest.assertParseError("a]");
    }

    private static void assertParseError(String spec) {
        try {
            NamedPathPruner.parse((String)spec);
            NamedPathPrunerTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testPruning() throws Exception {
        Jhob job1 = new Jhob("job1", "Job #1", "whatever");
        Jhob job2 = new Jhob("job2", "Job #2", "junk");
        Vhew view1 = new Vhew("All", "crap", new Jhob[]{job1, job2});
        Vhew view2 = new Vhew("Some", "less", new Jhob[]{job1});
        Stuff bean = new Stuff(new Jhob[]{job1, job2}, Arrays.asList(view1, view2));
        NamedPathPrunerTest.assertResult("{jobs:[{displayName:Job #1,name:job1},{displayName:Job #2,name:job2}],views:[{jobs:[{name:job1},{name:job2}],name:All},{jobs:[{name:job1}],name:Some}]}", bean, "jobs[name,displayName],views[name,jobs[name]]");
    }

    private static void assertResult(String expected, Object bean, String spec) throws Exception {
        Model model = new ModelBuilder().get(bean.getClass());
        StringWriter w = new StringWriter();
        model.writeTo(bean, (TreePruner)new NamedPathPruner(spec), Flavor.JSON.createDataWriter(bean, (Writer)w));
        NamedPathPrunerTest.assertEquals((String)expected, (String)w.toString().replace("\\\"", "").replace("\"", ""));
    }

    @ExportedBean
    public static class Vhew {
        @Exported
        public String name;
        @Exported
        public String trash;
        @Exported
        public Jhob[] jobs;

        public Vhew(String name, String trash, Jhob[] jobs) {
            this.name = name;
            this.trash = trash;
            this.jobs = (Jhob[])jobs.clone();
        }
    }

    @ExportedBean
    public static class Jhob {
        @Exported
        public String name;
        @Exported
        public String displayName;
        @Exported
        public String trash;

        public Jhob(String name, String displayName, String trash) {
            this.name = name;
            this.displayName = displayName;
            this.trash = trash;
        }
    }

    @ExportedBean
    public static class Stuff {
        @Exported
        public Jhob[] jobs;
        @Exported
        public List<Vhew> views;

        public Stuff(Jhob[] jobs, List<Vhew> views) {
            this.jobs = (Jhob[])jobs.clone();
            this.views = views;
        }
    }
}

