/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.export;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import junit.framework.TestCase;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.kohsuke.stapler.export.Flavor;
import org.kohsuke.stapler.export.Model;
import org.kohsuke.stapler.export.ModelBuilder;
import org.kohsuke.stapler.export.XMLDataWriter;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class XMLDataWriterTest
extends TestCase {
    public XMLDataWriterTest(String n) {
        super(n);
    }

    private static <T> String serialize(T bean, Class<T> clazz) throws IOException {
        StringWriter w = new StringWriter();
        Model model = new ModelBuilder().get(clazz);
        model.writeTo(bean, Flavor.XML.createDataWriter(bean, (Writer)w));
        return w.toString();
    }

    public void testSimpleUsage() throws Exception {
        XMLDataWriterTest.assertEquals((String)"<x><a>aval</a><c>cval</c></x>", (String)XMLDataWriterTest.serialize(new X(), X.class));
    }

    public void testInheritance() throws Exception {
        XMLDataWriterTest.assertEquals((String)"<container><polymorph><basic>super</basic><generic>sub</generic><specific>sub</specific></polymorph></container>", (String)XMLDataWriterTest.serialize(new Container(), Container.class));
    }

    private void assertValidXML(String s) throws Exception {
        SAXParser p = SAXParserFactory.newInstance().newSAXParser();
        p.parse(new InputSource(new StringReader(s)), new DefaultHandler());
    }

    public void testAnonymousClass() throws Exception {
        this.assertValidXML(XMLDataWriterTest.serialize(new X(){}, X.class));
    }

    public void testPrimitiveArrays() throws Exception {
        XMLDataWriterTest.assertEquals((String)"<PA><v>1</v><v>2</v><v>3</v></PA>", (String)XMLDataWriterTest.serialize(new PA(), PA.class));
    }

    public void testMakeXmlName() {
        XMLDataWriterTest.assertEquals((String)"_", (String)XMLDataWriter.makeXmlName((String)""));
        XMLDataWriterTest.assertEquals((String)"abc", (String)XMLDataWriter.makeXmlName((String)"abc"));
        XMLDataWriterTest.assertEquals((String)"abc", (String)XMLDataWriter.makeXmlName((String)"/abc"));
        XMLDataWriterTest.assertEquals((String)"abc", (String)XMLDataWriter.makeXmlName((String)"/a/b/c/"));
    }

    @ExportedBean
    public static class PA {
        @Exported
        public int[] v = new int[]{1, 2, 3};
    }

    @ExportedBean
    public static class Container {
        @Exported
        public Super polymorph = new Sub();
    }

    public static class Sub
    extends Super {
        @Override
        public String generic() {
            return "sub";
        }

        @Exported
        public String specific() {
            return "sub";
        }
    }

    @ExportedBean(defaultVisibility=2)
    public static abstract class Super {
        @Exported
        public String basic = "super";

        @Exported
        public abstract String generic();
    }

    @ExportedBean
    public static class X {
        @Exported
        public String a = "aval";
        public String b = "bval";

        @Exported
        public String getC() {
            return "cval";
        }

        public String getD() {
            return "dval";
        }
    }
}

