/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import com.google.common.base.Function;
import com.google.common.collect.MapMaker;
import java.net.URL;
import java.util.Map;
import org.kohsuke.stapler.MetaClass;
import org.kohsuke.stapler.MetaClassLoader;
import org.kohsuke.stapler.Optional;
import org.kohsuke.stapler.ScriptLoadException;

public abstract class CachingScriptLoader<S, E extends Exception> {
    private final Map<String, Optional<S>> scripts = new MapMaker().softValues().makeComputingMap(new Function<String, Optional<S>>(){

        public Optional<S> apply(String from) {
            try {
                return Optional.create(CachingScriptLoader.this.loadScript(from));
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ScriptLoadException(e);
            }
        }
    });

    public S findScript(String name) throws E {
        if (MetaClass.NO_CACHE) {
            return this.loadScript(name);
        }
        return this.scripts.get(name).get();
    }

    protected abstract S loadScript(String var1) throws E;

    public synchronized void clearScripts() {
        this.scripts.clear();
    }

    protected final URL findResource(String name, ClassLoader cl) {
        URL res = null;
        if (MetaClassLoader.debugLoader != null) {
            res = this.getResource(name, MetaClassLoader.debugLoader.loader);
        }
        if (res == null) {
            res = this.getResource(name, cl);
        }
        return res;
    }

    protected abstract URL getResource(String var1, ClassLoader var2);
}

