/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.kohsuke.stapler.CapturedParameterNames;
import org.kohsuke.stapler.Function;
import org.kohsuke.stapler.FunctionList;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.EmptyVisitor;

public final class ClassDescriptor {
    public final Class clazz;
    public final FunctionList methods;
    public final Field[] fields;
    private static final Logger LOGGER = Logger.getLogger(ClassDescriptor.class.getName());
    private static final String[] EMPTY_ARRAY = new String[0];

    public ClassDescriptor(Class clazz, Class ... wrappers) {
        this.clazz = clazz;
        this.fields = clazz.getFields();
        ArrayList<Function> functions = new ArrayList<Function>();
        for (Method method : clazz.getMethods()) {
            functions.add(new Function.InstanceFunction(method).protectBy(method));
        }
        if (wrappers != null) {
            for (GenericDeclaration genericDeclaration : wrappers) {
                for (Method m : ((Class)genericDeclaration).getMethods()) {
                    Class<?>[] p;
                    if (!Modifier.isStatic(m.getModifiers()) || (p = m.getParameterTypes()).length == 0 || p[0].isAssignableFrom(clazz)) continue;
                    functions.add(new Function.StaticFunction(m).protectBy(m));
                }
            }
        }
        this.methods = new FunctionList(functions);
    }

    public static String[] loadParameterNames(Method m) {
        CapturedParameterNames cpn = m.getAnnotation(CapturedParameterNames.class);
        if (cpn != null) {
            return cpn.value();
        }
        try {
            String[] n = ASM.loadParametersFromAsm(m);
            if (n != null) {
                return n;
            }
        }
        catch (LinkageError e) {
            LOGGER.log(Level.FINE, "Incompatible ASM", e);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to load a class file", e);
        }
        Class<?> c = m.getDeclaringClass();
        URL url = c.getClassLoader().getResource(c.getName().replace('.', '/').replace('$', '/') + '/' + m.getName() + ".stapler");
        if (url != null) {
            try {
                return IOUtils.toString((InputStream)url.openStream()).split(",");
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to load " + url, e);
                return EMPTY_ARRAY;
            }
        }
        return EMPTY_ARRAY;
    }

    public static String[] loadParameterNames(Constructor<?> m) {
        CapturedParameterNames cpn = m.getAnnotation(CapturedParameterNames.class);
        if (cpn != null) {
            return cpn.value();
        }
        try {
            String[] n = ASM.loadParametersFromAsm(m);
            if (n != null) {
                return n;
            }
        }
        catch (LinkageError e) {
            LOGGER.log(Level.FINE, "Incompatible ASM", e);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to load a class file", e);
        }
        return EMPTY_ARRAY;
    }

    private static class ASM {
        private ASM() {
        }

        private static String[] loadParametersFromAsm(final Method m) throws IOException {
            String[] paramNames = new String[m.getParameterTypes().length];
            if (paramNames.length == 0) {
                return paramNames;
            }
            Class<?> c = m.getDeclaringClass();
            URL clazz = c.getClassLoader().getResource(c.getName().replace('.', '/') + ".class");
            if (clazz == null) {
                return null;
            }
            final TreeMap localVars = new TreeMap();
            ClassReader r = new ClassReader(clazz.openStream());
            r.accept((ClassVisitor)new EmptyVisitor(){
                final String md;
                final int limit;
                {
                    this.md = Type.getMethodDescriptor((Method)m);
                    this.limit = (m.getModifiers() & 8) != 0 ? 0 : 1;
                }

                public MethodVisitor visitMethod(int access, String methodName, String desc, String signature, String[] exceptions) {
                    if (methodName.equals(m.getName()) && desc.equals(this.md)) {
                        return new EmptyVisitor(){

                            public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
                                if (index >= limit) {
                                    localVars.put(index, name);
                                }
                            }
                        };
                    }
                    return null;
                }
            }, false);
            int i = 0;
            Iterator i$ = localVars.values().iterator();
            while (i$.hasNext()) {
                String s;
                paramNames[i] = s = (String)i$.next();
                if (++i != paramNames.length) continue;
                return paramNames;
            }
            return null;
        }

        private static String[] loadParametersFromAsm(final Constructor m) throws IOException {
            String[] paramNames = new String[m.getParameterTypes().length];
            if (paramNames.length == 0) {
                return paramNames;
            }
            Class c = m.getDeclaringClass();
            URL clazz = c.getClassLoader().getResource(c.getName().replace('.', '/') + ".class");
            if (clazz == null) {
                return null;
            }
            final TreeMap localVars = new TreeMap();
            ClassReader r = new ClassReader(clazz.openStream());
            r.accept((ClassVisitor)new EmptyVisitor(){
                final String md;
                {
                    this.md = ASM.getConstructorDescriptor(m);
                }

                public MethodVisitor visitMethod(int access, String methodName, String desc, String signature, String[] exceptions) {
                    if (methodName.equals("<init>") && desc.equals(this.md)) {
                        return new EmptyVisitor(){

                            public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
                                if (index > 0) {
                                    localVars.put(index, name);
                                }
                            }
                        };
                    }
                    return null;
                }
            }, false);
            int i = 0;
            Iterator i$ = localVars.values().iterator();
            while (i$.hasNext()) {
                String s;
                paramNames[i] = s = (String)i$.next();
                if (++i != paramNames.length) continue;
                return paramNames;
            }
            return null;
        }

        private static String getConstructorDescriptor(Constructor c) {
            StringBuilder buf = new StringBuilder("(");
            for (Class<?> p : c.getParameterTypes()) {
                buf.append(Type.getDescriptor(p));
            }
            return buf.append(")V").toString();
        }
    }
}

