/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import java.util.WeakHashMap;
import org.kohsuke.stapler.TearOffSupport;

public class MetaClassLoader
extends TearOffSupport {
    public final MetaClassLoader parent;
    public final ClassLoader loader;
    public static MetaClassLoader debugLoader = null;
    private static final Map<ClassLoader, MetaClassLoader> classMap = new WeakHashMap<ClassLoader, MetaClassLoader>();

    public MetaClassLoader(ClassLoader loader) {
        this.loader = loader;
        this.parent = MetaClassLoader.get(loader.getParent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MetaClassLoader get(ClassLoader cl) {
        if (cl == null) {
            return null;
        }
        Map<ClassLoader, MetaClassLoader> map = classMap;
        synchronized (map) {
            MetaClassLoader mc = classMap.get(cl);
            if (mc == null) {
                mc = new MetaClassLoader(cl);
                classMap.put(cl, mc);
            }
            return mc;
        }
    }

    static {
        try {
            String path = System.getProperty("stapler.resourcePath");
            if (path != null) {
                String[] tokens = path.split(";");
                URL[] urls = new URL[tokens.length];
                for (int i = 0; i < tokens.length; ++i) {
                    urls[i] = new File(tokens[i]).toURI().toURL();
                }
                debugLoader = new MetaClassLoader(new URLClassLoader(urls));
            }
        }
        catch (MalformedURLException e) {
            throw new Error(e);
        }
    }
}

