/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.export;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.kohsuke.stapler.export.DataWriter;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.kohsuke.stapler.export.FieldProperty;
import org.kohsuke.stapler.export.MethodProperty;
import org.kohsuke.stapler.export.ModelBuilder;
import org.kohsuke.stapler.export.NotExportableException;
import org.kohsuke.stapler.export.Property;
import org.kohsuke.stapler.export.TreePruner;

public class Model<T> {
    public final Class<T> type;
    public final Model<? super T> superModel;
    private final Property[] properties;
    final ModelBuilder parent;
    final int defaultVisibility;
    private volatile Properties javadoc;

    Model(ModelBuilder parent, Class<T> type) {
        Exported exported;
        this.parent = parent;
        this.type = type;
        ExportedBean eb = type.getAnnotation(ExportedBean.class);
        if (eb == null) {
            throw new NotExportableException(type);
        }
        this.defaultVisibility = eb.defaultVisibility();
        Class<T> sc = type.getSuperclass();
        this.superModel = sc != null && sc.getAnnotation(ExportedBean.class) != null ? parent.get(sc) : null;
        ArrayList<Property> properties = new ArrayList<Property>();
        for (Field field : type.getFields()) {
            if (field.getDeclaringClass() != type || (exported = field.getAnnotation(Exported.class)) == null) continue;
            properties.add(new FieldProperty(this, field, exported));
        }
        for (AccessibleObject accessibleObject : type.getMethods()) {
            if (((Method)accessibleObject).getDeclaringClass() != type || (exported = ((Method)accessibleObject).getAnnotation(Exported.class)) == null) continue;
            properties.add(new MethodProperty(this, (Method)accessibleObject, exported));
        }
        this.properties = properties.toArray(new Property[properties.size()]);
        Arrays.sort(this.properties);
        parent.models.put(type, this);
    }

    public List<Property> getProperties() {
        return Collections.unmodifiableList(Arrays.asList(this.properties));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Properties getJavadoc() {
        if (this.javadoc != null) {
            return this.javadoc;
        }
        Model model = this;
        synchronized (model) {
            if (this.javadoc != null) {
                return this.javadoc;
            }
            Properties p = new Properties();
            InputStream is = this.type.getClassLoader().getResourceAsStream(this.type.getName().replace('$', '/').replace('.', '/') + ".javadoc");
            if (is != null) {
                try {
                    try {
                        p.load(is);
                    }
                    finally {
                        is.close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to load javadoc for " + this.type, e);
                }
            }
            this.javadoc = p;
            return this.javadoc;
        }
    }

    public void writeTo(T object, DataWriter writer) throws IOException {
        this.writeTo(object, 0, writer);
    }

    public void writeTo(T object, TreePruner pruner, DataWriter writer) throws IOException {
        writer.startObject();
        this.writeNestedObjectTo(object, pruner, writer);
        writer.endObject();
    }

    public void writeTo(T object, int baseVisibility, DataWriter writer) throws IOException {
        this.writeTo(object, new TreePruner.ByDepth(1 - baseVisibility), writer);
    }

    void writeNestedObjectTo(T object, TreePruner pruner, DataWriter writer) throws IOException {
        if (this.superModel != null) {
            this.superModel.writeNestedObjectTo(object, pruner, writer);
        }
        for (Property p : this.properties) {
            p.writeTo(object, pruner, writer);
        }
    }
}

