/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.export;

import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.kohsuke.stapler.export.CustomExportedBean;
import org.kohsuke.stapler.export.DataWriter;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.Model;
import org.kohsuke.stapler.export.ModelBuilder;
import org.kohsuke.stapler.export.NotExportableException;
import org.kohsuke.stapler.export.TreePruner;

public abstract class Property
implements Comparable<Property> {
    public final String name;
    final ModelBuilder owner;
    public final int visibility;
    public final Model parent;
    public final boolean inline;
    private String[] verboseMap;
    static final Set<Class> STRING_TYPES = new HashSet<Class>(Arrays.asList(String.class, URL.class));
    static final Set<Class> PRIMITIVE_TYPES = new HashSet<Class>(Arrays.asList(Integer.class, Long.class, Boolean.class, Short.class, Character.class, Float.class, Double.class));

    Property(Model parent, String name, Exported exported) {
        this.parent = parent;
        this.owner = parent.parent;
        this.name = exported.name().length() > 1 ? exported.name() : name;
        int v = exported.visibility();
        if (v == 0) {
            v = parent.defaultVisibility;
        }
        this.visibility = v;
        this.inline = exported.inline();
        String[] s = exported.verboseMap().split("/");
        this.verboseMap = s.length < 2 ? null : s;
    }

    @Override
    public int compareTo(Property that) {
        return this.name.compareTo(that.name);
    }

    public abstract Type getGenericType();

    public abstract Class getType();

    public abstract String getJavadoc();

    public void writeTo(Object object, TreePruner pruner, DataWriter writer) throws IOException {
        TreePruner child = pruner.accept(object, this);
        if (child == null) {
            return;
        }
        try {
            writer.name(this.name);
            this.writeValue(this.getValue(object), child, writer);
        }
        catch (IllegalAccessException e) {
            IOException x = new IOException("Failed to write " + this.name);
            x.initCause(e);
            throw x;
        }
        catch (InvocationTargetException e) {
            IOException x = new IOException("Failed to write " + this.name);
            x.initCause(e);
            throw x;
        }
    }

    public void writeTo(Object object, int depth, DataWriter writer) throws IOException {
        this.writeTo(object, new TreePruner.ByDepth(depth), writer);
    }

    private void writeValue(Object value, TreePruner pruner, DataWriter writer) throws IOException {
        this.writeValue(value, pruner, writer, false);
    }

    private void writeValue(Object value, TreePruner pruner, DataWriter writer, boolean skipIfFail) throws IOException {
        Model<?> model;
        block22: {
            if (value == null) {
                writer.valueNull();
                return;
            }
            if (value instanceof CustomExportedBean) {
                this.writeValue(((CustomExportedBean)value).toExportedObject(), pruner, writer);
                return;
            }
            Class<?> c = value.getClass();
            if (STRING_TYPES.contains(c)) {
                writer.value(value.toString());
                return;
            }
            if (PRIMITIVE_TYPES.contains(c)) {
                writer.valuePrimitive(value);
                return;
            }
            if (c.getComponentType() != null) {
                writer.startArray();
                if (value instanceof Object[]) {
                    for (Object item : (Object[])value) {
                        this.writeValue(item, pruner, writer, true);
                    }
                } else {
                    int len = Array.getLength(value);
                    for (int i = 0; i < len; ++i) {
                        this.writeValue(Array.get(value, i), pruner, writer, true);
                    }
                }
                writer.endArray();
                return;
            }
            if (value instanceof Collection) {
                writer.startArray();
                for (Object item : (Collection)value) {
                    this.writeValue(item, pruner, writer, true);
                }
                writer.endArray();
                return;
            }
            if (value instanceof Map) {
                if (this.verboseMap != null) {
                    writer.startArray();
                    for (Map.Entry e : ((Map)value).entrySet()) {
                        writer.startObject();
                        writer.name(this.verboseMap[0]);
                        this.writeValue(e.getKey(), pruner, writer);
                        writer.name(this.verboseMap[1]);
                        this.writeValue(e.getValue(), pruner, writer);
                        writer.endObject();
                    }
                    writer.endArray();
                } else {
                    writer.startObject();
                    for (Map.Entry e : ((Map)value).entrySet()) {
                        writer.name(e.getKey().toString());
                        this.writeValue(e.getValue(), pruner, writer);
                    }
                    writer.endObject();
                }
                return;
            }
            if (value instanceof Date) {
                writer.valuePrimitive(((Date)value).getTime());
                return;
            }
            if (value instanceof Calendar) {
                writer.valuePrimitive(((Calendar)value).getTimeInMillis());
                return;
            }
            if (value instanceof Enum) {
                writer.value(value.toString());
                return;
            }
            writer.startObject();
            model = null;
            try {
                model = this.owner.get(c);
            }
            catch (NotExportableException e) {
                if (skipIfFail) break block22;
                throw e;
            }
        }
        if (model != null) {
            model.writeNestedObjectTo(value, pruner, writer);
        }
        writer.endObject();
    }

    protected abstract Object getValue(Object var1) throws IllegalAccessException, InvocationTargetException;
}

