/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.jelly;

import java.lang.reflect.Field;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.JellyException;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.TagLibrary;
import org.apache.commons.jelly.expression.Expression;
import org.apache.commons.jelly.expression.ExpressionFactory;
import org.apache.commons.jelly.expression.ExpressionSupport;
import org.apache.commons.jelly.impl.ExpressionScript;
import org.apache.commons.jelly.impl.ScriptBlock;
import org.apache.commons.jelly.parser.XMLParser;
import org.kohsuke.stapler.MetaClassLoader;
import org.kohsuke.stapler.jelly.InternationalizedStringExpression;
import org.kohsuke.stapler.jelly.JellyClassLoaderTearOff;
import org.kohsuke.stapler.jelly.ReallyStaticTagLibrary;
import org.kohsuke.stapler.jelly.ResourceBundle;
import org.kohsuke.stapler.jelly.ThisTagLibrary;

class CustomJellyContext
extends JellyContext {
    private JellyClassLoaderTearOff jclt;
    private static final Pattern RESOURCE_LITERAL_STRING = Pattern.compile("(\"%[^\"]+\")|('%[^']+')");

    CustomJellyContext() {
        this.init();
    }

    CustomJellyContext(URL url) {
        super(url);
        this.init();
    }

    CustomJellyContext(URL url, URL url1) {
        super(url, url1);
        this.init();
    }

    CustomJellyContext(JellyContext jellyContext) {
        super(jellyContext);
        this.init();
    }

    CustomJellyContext(JellyContext jellyContext, URL url) {
        super(jellyContext, url);
        this.init();
    }

    CustomJellyContext(JellyContext jellyContext, URL url, URL url1) {
        super(jellyContext, url, url1);
        this.init();
    }

    private void init() {
        this.registerTagLibrary("", ReallyStaticTagLibrary.INSTANCE);
        this.registerTagLibrary("this", ThisTagLibrary.INSTANCE);
    }

    protected XMLParser createXMLParser() {
        return new CustomXMLParser();
    }

    public void setClassLoader(ClassLoader classLoader) {
        super.setClassLoader(classLoader);
        this.jclt = (JellyClassLoaderTearOff)MetaClassLoader.get((ClassLoader)classLoader).loadTearOff(JellyClassLoaderTearOff.class);
    }

    public TagLibrary getTagLibrary(String namespaceURI) {
        TagLibrary tl = super.getTagLibrary(namespaceURI);
        if (tl == null && this.jclt != null && (tl = this.jclt.getTagLibrary(namespaceURI)) != null) {
            this.registerTagLibrary(namespaceURI, tl);
        }
        return tl;
    }

    private static class CustomXMLParser
    extends XMLParser
    implements ExpressionFactory {
        private ResourceBundle resourceBundle;
        private static Field escapeByDefaultField;

        private CustomXMLParser() {
        }

        protected ExpressionFactory createExpressionFactory() {
            return this;
        }

        public Expression createExpression(String text) throws JellyException {
            if (text.startsWith("%")) {
                return this.createI18nExp(text);
            }
            Matcher m = RESOURCE_LITERAL_STRING.matcher(text);
            if (m.find()) {
                StringBuilder buf = new StringBuilder();
                HashMap<String, InternationalizedStringExpression> resourceLiterals = new HashMap<String, InternationalizedStringExpression>();
                int e = 0;
                do {
                    buf.append(text.substring(e, m.start()));
                    String varName = "__resourceLiteral__" + resourceLiterals.size() + "__";
                    InternationalizedStringExpression exp = this.createI18nExp(this.unquote(m.group()));
                    resourceLiterals.put(varName, exp);
                    buf.append(varName).append(".evaluate(context)");
                    e = m.end();
                } while (m.find());
                buf.append(text.substring(e));
                return new I18nExpWithArgsExpression(text, resourceLiterals, buf.toString());
            }
            return JellyClassLoaderTearOff.EXPRESSION_FACTORY.createExpression(text);
        }

        private InternationalizedStringExpression createI18nExp(String text) throws JellyException {
            return new InternationalizedStringExpression(this.getResourceBundle(), text);
        }

        protected void addExpressionScript(ScriptBlock script, Expression exp) {
            try {
                if (exp instanceof InternationalizedStringExpression && escapeByDefaultField.getBoolean((Object)this)) {
                    script.addScript((Script)new ExpressionScript(((InternationalizedStringExpression)exp).escape()));
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            super.addExpressionScript(script, exp);
        }

        private String unquote(String s) {
            return s.substring(1, s.length() - 1);
        }

        private ResourceBundle getResourceBundle() {
            if (this.resourceBundle == null) {
                this.resourceBundle = ResourceBundle.load(this.locator.getSystemId());
            }
            return this.resourceBundle;
        }

        static {
            try {
                escapeByDefaultField = XMLParser.class.getDeclaredField("escapeByDefault");
                escapeByDefaultField.setAccessible(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private static class I18nExpWithArgsExpression
        extends ExpressionSupport {
            final Expression innerExpression;
            private final String text;
            private final Map<String, InternationalizedStringExpression> resourceLiterals;

            public I18nExpWithArgsExpression(String text, Map<String, InternationalizedStringExpression> resourceLiterals, String exp) throws JellyException {
                this.text = text;
                this.resourceLiterals = resourceLiterals;
                this.innerExpression = JellyClassLoaderTearOff.EXPRESSION_FACTORY.createExpression(exp);
            }

            public String getExpressionText() {
                return this.text;
            }

            public Object evaluate(JellyContext context) {
                context = new CustomJellyContext(context);
                context.setVariables(this.resourceLiterals);
                return this.innerExpression.evaluate(context);
            }
        }
    }
}

