package org.hyperscala.bootstrap.component

import org.powerscala.enum.{Enumerated, EnumEntry}
import org.hyperscala.html.HTMLTag

/**
 * @author Matt Hicks <matt@outr.com>
 */
class Glyphicon(val className: String) extends EnumEntry {
  def apply[T <: HTMLTag](t: T) = {
    t.clazz := t.clazz().filter(s => s.startsWith("glyphicon"))
    t.clazz += "glyphicon"
    t.clazz += s"glyphicon-$className"
    t
  }
  def create() = apply(new org.hyperscala.html.tag.Span)
}

object Glyphicon extends Enumerated[Glyphicon] {
  val Asterisk = new Glyphicon("asterisk")
  val Plus = new Glyphicon("plus")
  val Euro = new Glyphicon("euro")
  val Minus = new Glyphicon("minus")
  val Cloud = new Glyphicon("cloud")
  val Envelope = new Glyphicon("envelope")
  val Pencil = new Glyphicon("pencil")
  val Glass = new Glyphicon("glass")
  val Music = new Glyphicon("music")
  val Search = new Glyphicon("search")
  val Heart = new Glyphicon("heart")
  val Star = new Glyphicon("star")
  val StarEmpty = new Glyphicon("star-empty")
  val User = new Glyphicon("user")
  val Film = new Glyphicon("film")
  val ThLarge = new Glyphicon("th-large")
  val Th = new Glyphicon("th")
  val ThList = new Glyphicon("th-list")
  val Ok = new Glyphicon("ok")
  val Remove = new Glyphicon("remove")
  val ZoomIn = new Glyphicon("zoom-in")
  val ZoomOut = new Glyphicon("zoom-out")
  val Off = new Glyphicon("off")
  val Signal = new Glyphicon("signal")
  val Cog = new Glyphicon("cog")
  val Trash = new Glyphicon("trash")
  val Home = new Glyphicon("home")
  val File = new Glyphicon("file")
  val Time = new Glyphicon("time")
  val Road = new Glyphicon("road")
  val DownloadAlt = new Glyphicon("download-alt")
  val Download = new Glyphicon("download")
  val Upload = new Glyphicon("upload")
  val Inbox = new Glyphicon("inbox")
  val PlayCircle = new Glyphicon("play-circle")
  val Repeat = new Glyphicon("repeat")
  val Refresh = new Glyphicon("refresh")
  val ListAlt = new Glyphicon("list-alt")
  val Lock = new Glyphicon("lock")
  val Flag = new Glyphicon("flag")
  val Headphones = new Glyphicon("headphones")
  val VolumeOff = new Glyphicon("volume-off")
  val VolumeDown = new Glyphicon("volume-down")
  val VolumeUp = new Glyphicon("volume-up")
  val Qrcode = new Glyphicon("qrcode")
  val Barcode = new Glyphicon("barcode")
  val Tag = new Glyphicon("tag")
  val Tags = new Glyphicon("tags")
  val Book = new Glyphicon("book")
  val Bookmark = new Glyphicon("bookmark")
  val Print = new Glyphicon("print")
  val Camera = new Glyphicon("camera")
  val Font = new Glyphicon("font")
  val Bold = new Glyphicon("bold")
  val Italic = new Glyphicon("italic")
  val TextHeight = new Glyphicon("text-height")
  val TextWidth = new Glyphicon("text-width")
  val AlignLeft = new Glyphicon("align-left")
  val AlignCenter = new Glyphicon("align-center")
  val AlignRight = new Glyphicon("align-right")
  val AlignJustify = new Glyphicon("align-justify")
  val List = new Glyphicon("list")
  val IndentLeft = new Glyphicon("indent-left")
  val IndentRight = new Glyphicon("indent-right")
  val FacetimeVideo = new Glyphicon("facetime-video")
  val Picture = new Glyphicon("picture")
  val MapMarker = new Glyphicon("map-marker")
  val Adjust = new Glyphicon("adjust")
  val Tint = new Glyphicon("tint")
  val Edit = new Glyphicon("edit")
  val Share = new Glyphicon("share")
  val Check = new Glyphicon("check")
  val Move = new Glyphicon("move")
  val StepBackward = new Glyphicon("step-backward")
  val FastBackward = new Glyphicon("fast-backward")
  val Backward = new Glyphicon("backward")
  val Play = new Glyphicon("play")
  val Pause = new Glyphicon("pause")
  val Stop = new Glyphicon("stop")
  val Forward = new Glyphicon("forward")
  val FastForward = new Glyphicon("fast-forward")
  val StepForward = new Glyphicon("step-forward")
  val Eject = new Glyphicon("eject")
  val ChevronLeft = new Glyphicon("chevron-left")
  val ChevronRight = new Glyphicon("chevron-right")
  val PlusSign = new Glyphicon("plus-sign")
  val MinusSign = new Glyphicon("minus-sign")
  val RemoveSign = new Glyphicon("remove-sign")
  val OkSign = new Glyphicon("ok-sign")
  val QuestionSign = new Glyphicon("question-sign")
  val InfoSign = new Glyphicon("info-sign")
  val Screenshot = new Glyphicon("screenshot")
  val RemoveCircle = new Glyphicon("remove-circle")
  val OkCircle = new Glyphicon("ok-circle")
  val BanCircle = new Glyphicon("ban-circle")
  val ArrowLeft = new Glyphicon("arrow-left")
  val ArrowRight = new Glyphicon("arrow-right")
  val ArrowUp = new Glyphicon("arrow-up")
  val ArrowDown = new Glyphicon("arrow-down")
  val ShareAlt = new Glyphicon("share-alt")
  val ResizeFull = new Glyphicon("resize-full")
  val ResizeSmall = new Glyphicon("resize-small")
  val ExclamationSign = new Glyphicon("exclamation-sign")
  val Gift = new Glyphicon("gift")
  val Leaf = new Glyphicon("leaf")
  val Fire = new Glyphicon("fire")
  val EyeOpen = new Glyphicon("eye-open")
  val EyeClose = new Glyphicon("eye-close")
  val WarningSign = new Glyphicon("warning-sign")
  val Plane = new Glyphicon("plane")
  val Calendar = new Glyphicon("calendar")
  val Random = new Glyphicon("random")
  val Comment = new Glyphicon("comment")
  val Magnet = new Glyphicon("magnet")
  val ChevronUp = new Glyphicon("chevron-up")
  val ChevronDown = new Glyphicon("chevron-down")
  val Retweet = new Glyphicon("retweet")
  val ShoppingCart = new Glyphicon("shopping-cart")
  val FolderClose = new Glyphicon("folder-close")
  val FolderOpen = new Glyphicon("folder-open")
  val ResizeVertical = new Glyphicon("resize-vertical")
  val ResizeHorizontal = new Glyphicon("resize-horizontal")
  val Hdd = new Glyphicon("hdd")
  val Bullhorn = new Glyphicon("bullhorn")
  val Bell = new Glyphicon("bell")
  val Certificate = new Glyphicon("certificate")
  val ThumbsUp = new Glyphicon("thumbs-up")
  val ThumbsDown = new Glyphicon("thumbs-down")
  val HandRight = new Glyphicon("hand-right")
  val HandLeft = new Glyphicon("hand-left")
  val HandUp = new Glyphicon("hand-up")
  val HandDown = new Glyphicon("hand-down")
  val CircleArrowRight = new Glyphicon("circle-arrow-right")
  val CircleArrowLeft = new Glyphicon("circle-arrow-left")
  val CircleArrowUp = new Glyphicon("circle-arrow-up")
  val CircleArrowDown = new Glyphicon("circle-arrow-down")
  val Globe = new Glyphicon("globe")
  val Wrench = new Glyphicon("wrench")
  val Tasks = new Glyphicon("tasks")
  val Filter = new Glyphicon("filter")
  val Briefcase = new Glyphicon("briefcase")
  val Fullscreen = new Glyphicon("fullscreen")
  val Dashboard = new Glyphicon("dashboard")
  val Paperclip = new Glyphicon("paperclip")
  val HeartEmpty = new Glyphicon("heart-empty")
  val Link = new Glyphicon("link")
  val Phone = new Glyphicon("phone")
  val Pushpin = new Glyphicon("pushpin")
  val Usd = new Glyphicon("usd")
  val Gbp = new Glyphicon("gbp")
  val Sort = new Glyphicon("sort")
  val SortByAlphabet = new Glyphicon("sort-by-alphabet")
  val SortByAlphabetAlt = new Glyphicon("sort-by-alphabet-alt")
  val SortByOrder = new Glyphicon("sort-by-order")
  val SortByOrderAlt = new Glyphicon("sort-by-order-alt")
  val SortByAttributes = new Glyphicon("sort-by-attributes")
  val SortByAttributesAlt = new Glyphicon("sort-by-attributes-alt")
  val Unchecked = new Glyphicon("unchecked")
  val Expand = new Glyphicon("expand")
  val CollapseDown = new Glyphicon("collapse-down")
  val CollapseUp = new Glyphicon("collapse-up")
  val LogIn = new Glyphicon("log-in")
  val Flash = new Glyphicon("flash")
  val LogOut = new Glyphicon("log-out")
  val NewWindow = new Glyphicon("new-window")
  val Record = new Glyphicon("record")
  val Save = new Glyphicon("save")
  val Open = new Glyphicon("open")
  val Saved = new Glyphicon("saved")
  val Import = new Glyphicon("import")
  val Export = new Glyphicon("export")
  val Send = new Glyphicon("send")
  val FloppyDisk = new Glyphicon("floppy-disk")
  val FloppySaved = new Glyphicon("floppy-saved")
  val FloppyRemove = new Glyphicon("floppy-remove")
  val FloppySave = new Glyphicon("floppy-save")
  val FloppyOpen = new Glyphicon("floppy-open")
  val CreditCard = new Glyphicon("credit-card")
  val Transfer = new Glyphicon("transfer")
  val Cutlery = new Glyphicon("cutlery")
  val Header = new Glyphicon("header")
  val Compressed = new Glyphicon("compressed")
  val Earphone = new Glyphicon("earphone")
  val PhoneAlt = new Glyphicon("phone-alt")
  val Tower = new Glyphicon("tower")
  val Stats = new Glyphicon("stats")
  val SdVideo = new Glyphicon("sd-video")
  val HdVideo = new Glyphicon("hd-video")
  val Subtitles = new Glyphicon("subtitles")
  val SoundStereo = new Glyphicon("sound-stereo")
  val SoundDolby = new Glyphicon("sound-dolby")
  val Sound51 = new Glyphicon("sound-5-1")
  val Sound61 = new Glyphicon("sound-6-1")
  val Sound71 = new Glyphicon("sound-7-1")
  val CopyrightMark = new Glyphicon("copyright-mark")
  val RegistrationMark = new Glyphicon("registration-mark")
  val CloudDownload = new Glyphicon("cloud-download")
  val CloudUpload = new Glyphicon("cloud-upload")
  val TreeConifer = new Glyphicon("tree-conifer")
  val TreeDeciduous = new Glyphicon("tree-deciduous")
}