package org.hyperscala.examples.ui

import org.hyperscala.css.attributes.LineStyle
import org.hyperscala.examples.Example
import org.hyperscala.html._
import org.hyperscala.javascript.dsl._
import org.hyperscala.realtime._
import org.hyperscala.ui.ModalComponent
import org.hyperscala.web._
import org.powerscala.Color
import org.powerscala.property.Property

/**
 * @author Matt Hicks <matt@outr.com>
 */
class RealtimeFrameExample extends Webpage with Example {
  require(Realtime)

  println("RealtimeFrameExample...")
  private val count = Property[Int](default = Some(0))

  body.contents += new tag.P {
    contents += "RealtimeFrame extends an IFrame to allow customized pages to be instantiated and then assigned from within the parent page."
  }

  val frame = new RealtimeFrame("/example/realtime/realtimeframe.html") {
    style.borderColor := Color.Red
    style.borderStyle := LineStyle.Solid
    style.borderWidth := 2.px
    style.borderRadius := 10.px
    style.width := 400.px
    style.height := 200.px

    connected[Webpage] {
      case webpage => currentPage := new FramedPage("Preloaded Page")
    }
  }

  body.contents += frame
  body.contents += new tag.Button(content = "Load") {
    clickEvent.onRealtime {
      case evt => {
        count := count() + 1
        val page = new FramedPage(s"Page ${count()}")
        frame.currentPage := page
      }
    }
  }
}

class FramedPage(message: String) extends Webpage {
  require(ModalComponent)

  this.eval("console.log('Wahoo!');")
  body.contents += new tag.Strong(content = s"Framed page! Message: $message")

  body.contents += new tag.Button(content = "Test") {
    clickEvent.onRealtime {
      case evt => {
        body.contents += new tag.P(content = "Added dynamically!")
      }
    }
  }
}